/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.GroupNode;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.apache.slide.util.logger.Logger;
import org.jdom.JDOMException;

public class SecurityImpl
implements Security {
    private static final String LOG_CHANNEL = (class$org$apache$slide$security$SecurityImpl == null ? (class$org$apache$slide$security$SecurityImpl = SecurityImpl.class$("org.apache.slide.security.SecurityImpl")) : class$org$apache$slide$security$SecurityImpl).getName();
    protected Logger logger;
    protected Namespace namespace;
    protected NamespaceConfig namespaceConfig;
    protected Hashtable rolesCache;
    protected int aclInheritanceType;
    private Map actionAggregation;
    private Map actionAggregationClosure;
    static /* synthetic */ Class class$org$apache$slide$security$SecurityImpl;
    static /* synthetic */ Class class$org$apache$slide$structure$ObjectNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    public SecurityImpl() {
    }

    public SecurityImpl(Namespace namespace, NamespaceConfig namespaceConfig) {
        this.init(namespace, namespaceConfig);
    }

    public void init(Namespace namespace, NamespaceConfig namespaceConfig) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.rolesCache = new Hashtable();
        this.aclInheritanceType = namespaceConfig.getAclInheritanceType();
        this.logger = namespace.getLogger();
        this.loadActionsCache(namespace, namespaceConfig);
    }

    public void setPermissions(SlideToken token, String object, Enumeration permissions) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, object);
        ObjectNode objectNode = objectUri.getStore().retrieveObject(objectUri);
        this.checkCredentials(token, objectNode, this.namespaceConfig.getGrantPermissionAction());
        this.checkCredentials(token, objectNode, this.namespaceConfig.getRevokePermissionAction());
        objectUri.getStore().revokePermissions(objectUri);
        while (permissions.hasMoreElements()) {
            NodePermission permission = (NodePermission)permissions.nextElement();
            objectUri.getStore().grantPermission(objectUri, permission);
        }
    }

    public void grantPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        this.grantPermission(token, object, subject, action, true);
    }

    public void grantPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        NodePermission permission = new NodePermission(object, subject, action, inheritable);
        this.grantPermission(token, permission);
    }

    public void grantPermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, permission.getObjectUri());
        ObjectNode object = objectUri.getStore().retrieveObject(objectUri);
        Enumeration permissions = this.enumeratePermissions(token, object);
        boolean alreadyPresent = false;
        while (permissions.hasMoreElements() && !alreadyPresent) {
            if (!permission.equals(permissions.nextElement())) continue;
            alreadyPresent = true;
        }
        if (!alreadyPresent) {
            this.checkCredentials(token, object, this.namespaceConfig.getGrantPermissionAction());
            objectUri.getStore().grantPermission(objectUri, permission);
        }
    }

    public void denyPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        this.denyPermission(token, object, subject, action, true);
    }

    public void denyPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        NodePermission permission = new NodePermission(object, subject, action, inheritable, true);
        this.denyPermission(token, permission);
    }

    public void denyPermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        if (!permission.isNegative()) {
            permission.setNegative(true);
        }
        this.grantPermission(token, permission);
    }

    public void revokePermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        this.checkCredentials(token, object, this.namespaceConfig.getRevokePermissionAction());
        NodePermission permission = new NodePermission(object, subject, action);
        Uri objectUri = this.namespace.getUri(token, object.getUri());
        objectUri.getStore().revokePermission(objectUri, permission);
    }

    public void revokePermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, permission.getObjectUri());
        ObjectNode object = objectUri.getStore().retrieveObject(objectUri);
        this.checkCredentials(token, object, this.namespaceConfig.getRevokePermissionAction());
        objectUri.getStore().revokePermission(objectUri, permission);
    }

    public void checkCredentials(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, AccessDeniedException {
        block10: {
            if (!token.isForceSecurity()) {
                return;
            }
            if (token.isForceStoreEnlistment()) {
                token = new SlideTokenWrapper(token, false);
            }
            try {
                if (!Configuration.useIntegratedSecurity()) break block10;
                Boolean permission = token.checkPermissionCache(object, action);
                if (permission == null) {
                    try {
                        Uri objectUri = this.namespace.getUri(token, object.getUri());
                        ObjectNode realObject = objectUri.getStore().retrieveObject(objectUri);
                        this.checkPermission(token, realObject, action);
                        token.cachePermission(object, action, true);
                        break block10;
                    }
                    catch (AccessDeniedException ade) {
                        token.cachePermission(object, action, false);
                        ade.fillInStackTrace();
                        throw ade;
                    }
                }
                if (!permission.booleanValue()) {
                    throw new AccessDeniedException(object.getUri(), this.getPrincipal(token).getPath().toString(), action.getUri());
                }
            }
            catch (ObjectNotFoundException e) {
                String subjectUri = "*** Could not determine principal ***";
                try {
                    subjectUri = this.getPrincipal(token).getPath().toString();
                }
                catch (Exception x) {
                    // empty catch block
                }
                throw new AccessDeniedException(object.getUri(), subjectUri, action.getUri());
            }
        }
    }

    public void checkPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, AccessDeniedException, ObjectNotFoundException {
        if (!this.hasPermission(object, subject, action)) {
            throw new AccessDeniedException(object.getUri(), subject.getUri(), action.getUri());
        }
    }

    public void checkPermission(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, AccessDeniedException, ObjectNotFoundException {
        if (!this.hasPermission(token, object, action)) {
            throw new AccessDeniedException(object.getUri(), this.getPrincipal(token).getUri(), action.getUri());
        }
    }

    public boolean hasPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        if (action == ActionNode.DEFAULT) {
            return true;
        }
        boolean granted = false;
        boolean denied = false;
        boolean rootObjectReached = false;
        ObjectNode courObject = object;
        Uri subjectUri = this.namespace.getUri(subject.getUri());
        Uri actionUri = this.namespace.getUri(action.getUri());
        while (!(granted || denied || rootObjectReached)) {
            Uri courUri = this.namespace.getUri(courObject.getUri());
            Enumeration permissions = courUri.getStore().enumeratePermissions(courUri);
            while (permissions.hasMoreElements()) {
                boolean oldGranted = granted;
                boolean oldDenied = denied;
                NodePermission permission = (NodePermission)permissions.nextElement();
                String permissionSubject = permission.getSubjectUri();
                if (permissionSubject == "self") {
                    boolean check = object.getUri().equals(subjectUri.toString());
                    if (permission.isInheritable()) {
                        String subjectUriString = subjectUri.toString();
                        if (!subjectUriString.endsWith("/")) {
                            subjectUriString = subjectUriString + "/";
                        }
                        check |= object.getUri().startsWith(subjectUriString);
                    }
                    granted = !permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                    denied = permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                } else if (permission.isInheritable() || permission.getObjectUri().equals(object.getUri())) {
                    if (permissionSubject.startsWith("/")) {
                        String permSubj = permission.getSubjectUri();
                        if (!permSubj.endsWith("/")) {
                            permSubj = permSubj + "/";
                        }
                        boolean match = subjectUri.toString().equals(permission.getSubjectUri()) || subjectUri.toString().startsWith(permSubj);
                        granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                        denied = permission.isNegative() && match;
                    } else if (permissionSubject.startsWith("+")) {
                        Uri permissionSubjectUri = this.namespace.getUri(permissionSubject.substring(1));
                        ObjectNode group = permissionSubjectUri.getStore().retrieveObject(permissionSubjectUri);
                        if (group instanceof GroupNode && group.hasChildren()) {
                            Enumeration groupMembers = group.enumerateChildren();
                            while (groupMembers.hasMoreElements()) {
                                oldGranted = granted;
                                oldDenied = denied;
                                Uri childUri = this.namespace.getUri((String)groupMembers.nextElement());
                                ObjectNode childNode = childUri.getStore().retrieveObject(childUri);
                                String childSubjectUri = childNode instanceof LinkNode ? ((LinkNode)childNode).getLinkedUri() : childNode.getUri();
                                String testUri = !childSubjectUri.endsWith("/") ? childSubjectUri + "/" : childSubjectUri;
                                boolean match = subjectUri.toString().equals(childSubjectUri) || subjectUri.toString().startsWith(testUri);
                                granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                                denied = permission.isNegative() && match;
                                granted |= oldGranted;
                                denied |= oldDenied;
                            }
                        }
                    } else {
                        granted = !permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                        denied = permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                    }
                }
                granted |= oldGranted;
                denied |= oldDenied;
            }
            Uri parentUri = courUri.getParentUri();
            if (parentUri != null) {
                courObject = parentUri.getStore().retrieveObject(parentUri);
                continue;
            }
            rootObjectReached = true;
        }
        if (denied) {
            return false;
        }
        return granted;
    }

    public boolean hasPermission(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        Boolean cachedPermission = token.checkPermissionCache(object, action);
        if (cachedPermission != null) {
            return cachedPermission;
        }
        return this.hasPermission(object, (SubjectNode)this.getPrincipal(token), action);
    }

    public Enumeration enumeratePermissions(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        return this.enumeratePermissions(token, object, false);
    }

    public Enumeration enumeratePermissions(SlideToken token, ObjectNode object, boolean includeInherited) throws ServiceAccessException, ObjectNotFoundException {
        return this.enumeratePermissions(token, object.getUri(), includeInherited);
    }

    public Enumeration enumeratePermissions(SlideToken token, String object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        return this.enumeratePermissions(token, object, false);
    }

    public Enumeration enumeratePermissions(SlideToken token, String object, boolean includeInherited) throws ServiceAccessException, ObjectNotFoundException {
        Uri objectUri = this.namespace.getUri(token, object);
        if (!includeInherited) {
            return objectUri.getStore().enumeratePermissions(objectUri);
        }
        ObjectNode objectNode = objectUri.getStore().retrieveObject(objectUri);
        Iterator i = this.retrieveAclSourceNodes(token, objectNode).iterator();
        Vector<NodePermission> permissions = new Vector<NodePermission>();
        while (i.hasNext()) {
            ObjectNode oNode = (ObjectNode)i.next();
            Uri oUri = this.namespace.getUri(token, oNode.getUri());
            Enumeration permEnum = oUri.getStore().enumeratePermissions(oUri);
            while (permEnum.hasMoreElements()) {
                NodePermission perm = (NodePermission)permEnum.nextElement();
                if (object.equals(oNode.getUri())) {
                    permissions.add(perm);
                    continue;
                }
                if (!perm.isInheritable()) continue;
                perm.setInheritedFrom(oNode.getUri());
                permissions.add(perm);
            }
        }
        return permissions.elements();
    }

    public List retrieveAclSourceNodes(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
        if (token.isForceStoreEnlistment()) {
            token = new SlideTokenWrapper(token, false);
        }
        switch (this.aclInheritanceType) {
            case 0: {
                Uri uri = this.namespace.getUri(token, object.getUri());
                result.add(uri.getStore().retrieveObject(uri));
                break;
            }
            case 1: {
                Uri uri = this.namespace.getUri(token, object.getUri());
                Uri rootUri = this.namespace.getUri(token, uri.getScope().toString());
                result.add(uri.getStore().retrieveObject(uri));
                result.add(rootUri.getStore().retrieveObject(rootUri));
                break;
            }
            case 2: {
                Uri uri = this.namespace.getUri(token, object.getUri());
                Enumeration enumeration = uri.getScopes();
                while (enumeration.hasMoreElements()) {
                    Uri element = this.namespace.getUri(token, (String)enumeration.nextElement(), false);
                    ObjectNode objectNode = element.getStore().retrieveObject(element);
                    result.add(objectNode);
                }
                break;
            }
            case 3: {
                break;
            }
        }
        return result;
    }

    public boolean hasRole(SlideToken token, String role) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode subject = this.getPrincipal(token);
        return this.hasRole(subject, role);
    }

    public boolean hasRole(ObjectNode object, String role) throws ServiceAccessException, ObjectNotFoundException {
        Class<?> roleClass;
        if (role.equals("nobody")) {
            return true;
        }
        String associatedRole = this.namespaceConfig.getRoleMapping(role);
        if (associatedRole != null) {
            if (associatedRole.equals("nobody")) {
                return true;
            }
        }
        if ((roleClass = (Class<?>)this.rolesCache.get(role)) == null && associatedRole != null && (roleClass = (Class<?>)this.rolesCache.get(associatedRole)) == null) {
            try {
                roleClass = Class.forName(associatedRole);
                this.rolesCache.put(role, roleClass);
                this.rolesCache.put(associatedRole, roleClass);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (roleClass == null) {
            try {
                roleClass = Class.forName(role);
                this.rolesCache.put(role, roleClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (roleClass == null) {
            return false;
        }
        return roleClass.isInstance(object);
    }

    public Enumeration getRoles(ObjectNode object) {
        Vector<String> result = new Vector<String>();
        result.addElement("nobody");
        Class<?> currentObjectClass = object.getClass();
        while (!currentObjectClass.equals(class$org$apache$slide$structure$ObjectNode == null ? SecurityImpl.class$("org.apache.slide.structure.ObjectNode") : class$org$apache$slide$structure$ObjectNode)) {
            Class<?>[] interfaces = currentObjectClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                String className = interfaces[i].getName();
                String associatedName = this.namespaceConfig.getRoleMapping(className);
                if (associatedName != null) {
                    result.addElement(associatedName);
                } else {
                    result.addElement(className);
                }
                ++i;
            }
            if ((currentObjectClass = currentObjectClass.getSuperclass()) != null) continue;
            throw new IllegalStateException("Invalid node");
        }
        return result.elements();
    }

    public Enumeration getRoles(SlideToken token) throws ServiceAccessException, ObjectNotFoundException {
        return this.getRoles(this.getPrincipal(token));
    }

    public Enumeration getRoles(SlideToken token, SubjectNode subjectNode) throws ServiceAccessException, ObjectNotFoundException {
        return this.getRoles(subjectNode);
    }

    public ObjectNode getPrincipal(SlideToken token) throws ServiceAccessException, ObjectNotFoundException {
        String user = token.getCredentialsToken().getPublicCredentials();
        if (user == null || user.equals("") || user.equals("/")) {
            return SubjectNode.UNAUTHENTICATED;
        }
        Uri subjectUri = this.namespace.getUri(token, this.namespaceConfig.getUsersPath() + "/" + user);
        try {
            return subjectUri.getStore().retrieveObject(subjectUri);
        }
        catch (ObjectNotFoundException e) {
            if (!this.namespaceConfig.isAutoCreateUsers()) {
                throw e;
            }
            try {
                Uri parentUri = subjectUri.getParentUri();
                ObjectNode parent = subjectUri.getStore().retrieveObject(parentUri);
                Enumeration childrenEnum = parent.enumerateChildren();
                Enumeration linksEnum = parent.enumerateLinks();
                Vector children = new Vector();
                while (childrenEnum.hasMoreElements()) {
                    children.addElement(childrenEnum.nextElement());
                }
                children.addElement(subjectUri.toString());
                Vector links = new Vector();
                while (linksEnum.hasMoreElements()) {
                    links.addElement(linksEnum.nextElement());
                }
                Class<?> objectClass = Class.forName(this.namespaceConfig.getAutoCreateUsersRole());
                Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SecurityImpl.class$("java.lang.String")) : class$java$lang$String};
                Object[] args = new Object[]{subjectUri.toString()};
                Constructor<?> constructor = objectClass.getConstructor(types);
                ObjectNode object = (ObjectNode)constructor.newInstance(args);
                subjectUri.getStore().createObject(subjectUri, object);
                Class[] types2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SecurityImpl.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = SecurityImpl.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$Vector == null ? (class$java$util$Vector = SecurityImpl.class$("java.util.Vector")) : class$java$util$Vector};
                Object[] args2 = new Object[]{parentUri.toString(), children, links};
                constructor = parent.getClass().getConstructor(types2);
                object = (ObjectNode)constructor.newInstance(args2);
                parentUri.getStore().storeObject(parentUri, object);
            }
            catch (ClassNotFoundException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (NoSuchMethodException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (InstantiationException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (InvocationTargetException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (IllegalAccessException ex) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (ObjectAlreadyExistsException ex) {
                e.printStackTrace();
                throw new ObjectNotFoundException(subjectUri);
            }
        }
        return subjectUri.getStore().retrieveObject(subjectUri);
    }

    private void loadActionsCache(Namespace namespace, NamespaceConfig namespaceConfig) {
        block7: {
            try {
                HashSet<ActionNode> aClosure;
                this.actionAggregation = new HashMap();
                this.actionAggregationClosure = new HashMap();
                String actionsPath = namespaceConfig.getActionsPath();
                Uri actionsPathUri = namespace.getUri(actionsPath);
                ObjectNode actionsPathNode = actionsPathUri.getStore().retrieveObject(actionsPathUri);
                Enumeration actions = actionsPathNode.enumerateChildren();
                while (actions.hasMoreElements()) {
                    ActionNode aNode = ActionNode.getActionNode((String)actions.nextElement());
                    Set directAggregates = this.getActionAggregates(aNode);
                    this.actionAggregation.put(aNode, directAggregates);
                    aClosure = new HashSet<ActionNode>();
                    aClosure.add(aNode);
                    aClosure.addAll(directAggregates);
                    this.actionAggregationClosure.put(aNode, aClosure);
                }
                Iterator keys = this.actionAggregationClosure.keySet().iterator();
                while (keys.hasNext()) {
                    ActionNode aNode = (ActionNode)keys.next();
                    aClosure = (HashSet<ActionNode>)this.actionAggregationClosure.get(aNode);
                    this.actionAggregationClosure.put(aNode, this.buildClosure(aClosure));
                }
                if (this.logger.isEnabled(LOG_CHANNEL, 6)) {
                    this.logger.log("Action aggregations loaded successfully", LOG_CHANNEL, 6);
                }
                if (!this.logger.isEnabled(LOG_CHANNEL, 7)) break block7;
                this.logger.log("\n@@@ Actions aggregations", LOG_CHANNEL, 7);
                Iterator i = this.actionAggregation.entrySet().iterator();
                while (i.hasNext()) {
                    this.logger.log("  " + i.next(), LOG_CHANNEL, 7);
                }
                this.logger.log("\n@@@ Action aggregations (transitive closure)", LOG_CHANNEL, 7);
                i = this.actionAggregationClosure.entrySet().iterator();
                while (i.hasNext()) {
                    this.logger.log("  " + i.next(), LOG_CHANNEL, 7);
                }
            }
            catch (Throwable e) {
                this.actionAggregation = null;
                this.actionAggregationClosure = null;
            }
        }
    }

    private Set buildClosure(Set aClosure) {
        HashSet result = new HashSet(aClosure);
        int size = 0;
        while (result.size() > size) {
            size = result.size();
            HashSet newResult = new HashSet();
            Iterator i = result.iterator();
            while (i.hasNext()) {
                newResult.addAll((Set)this.actionAggregationClosure.get(i.next()));
            }
            result = newResult;
        }
        return result;
    }

    private Set getActionAggregates(ActionNode aNode) throws SlideException, JDOMException {
        HashSet<ActionNode> result = new HashSet<ActionNode>();
        Uri aNodeUri = this.namespace.getUri(aNode.getUri());
        NodeRevisionDescriptor aNrd = aNodeUri.getStore().retrieveRevisionDescriptor(aNodeUri, new NodeRevisionNumber());
        NodeProperty membersProp = aNrd.getProperty("privilege-member-set");
        if (membersProp != null && membersProp.getValue() != null) {
            XMLValue membersVal = membersProp.getValue() instanceof XMLValue ? (XMLValue)membersProp.getValue() : new XMLValue((String)membersProp.getValue());
            Iterator mUris = membersVal.getHrefStrings().iterator();
            while (mUris.hasNext()) {
                result.add(ActionNode.getActionNode((String)mUris.next()));
            }
        }
        return result;
    }

    public boolean matchAction(SlideToken token, ActionNode checkAction, ActionNode permAction) throws ServiceAccessException {
        if (permAction == ActionNode.ALL) {
            return true;
        }
        if (this.actionAggregationClosure != null) {
            Set permActionSet = (Set)this.actionAggregationClosure.get(permAction);
            if (permActionSet == null) {
                this.logger.log("Unknown action " + permAction.getUri(), LOG_CHANNEL, 4);
                return false;
            }
            return permActionSet.contains(checkAction);
        }
        Uri u = this.namespace.getUri(token, checkAction.getUri());
        Store s = u.getStore();
        throw new ServiceAccessException((Service)s, "Actions cache not loaded");
    }

    public boolean matchPrincipal(SlideToken token, SubjectNode checkSubject, SubjectNode matchSubject) throws ServiceAccessException {
        Boolean b = token.checkMatchPrincipalCache(checkSubject, matchSubject);
        if (b != null) {
            return b;
        }
        boolean match = this.matchPrincipal(token, checkSubject, matchSubject, this.namespaceConfig.getNestedRolesMaxDepth());
        token.cacheMatchPrincipal(checkSubject, matchSubject, match);
        return match;
    }

    public boolean matchPrincipal(SlideToken token, SubjectNode checkSubject, SubjectNode matchSubject, int level) throws ServiceAccessException {
        if (matchSubject.equals(checkSubject)) {
            return true;
        }
        Uri groupUri = this.namespace.getUri(token, matchSubject.getUri());
        try {
            NodeRevisionDescriptor nrd = groupUri.getStore().retrieveRevisionDescriptor(groupUri, new NodeRevisionNumber());
            NodeProperty membersetProp = nrd.getProperty("group-member-set");
            if (membersetProp != null && membersetProp.getValue() != null) {
                XMLValue xmlVal = new XMLValue((String)membersetProp.getValue());
                List memberNodes = xmlVal.getHrefNodes();
                if (memberNodes.contains(checkSubject)) {
                    return true;
                }
                if (level > 0) {
                    int nextLevel = level - 1;
                    boolean match = false;
                    Iterator i = memberNodes.iterator();
                    while (!match && i.hasNext()) {
                        SubjectNode nextMatchNode = (SubjectNode)i.next();
                        if (!this.namespaceConfig.isRole(nextMatchNode.getUri()) && !this.namespaceConfig.isGroup(nextMatchNode.getUri())) continue;
                        match = this.matchPrincipal(token, checkSubject, nextMatchNode, nextLevel);
                    }
                    return match;
                }
                return false;
            }
            return false;
        }
        catch (RevisionDescriptorNotFoundException e) {
            return false;
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map getActionAggregation() {
        return Collections.unmodifiableMap(this.actionAggregation);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

