/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic.sample;

import java.util.Collection;
import java.util.Iterator;
import org.apache.slide.common.SlideException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.BasicResultSetImpl;
import org.apache.slide.search.basic.ComparableResourceImpl;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.IBasicResultSet;
import org.apache.slide.structure.SubjectNode;

public class BasicExpressionSample
implements IBasicExpression {
    String theExecutableCommand;
    IBasicExpressionFactory factory;

    BasicExpressionSample(String command, IBasicExpressionFactory factory) {
        this.theExecutableCommand = command;
        this.factory = factory;
    }

    BasicExpressionSample(String mergeOperator, Collection children, IBasicExpressionFactory factory) throws BadQueryException {
        this.factory = factory;
        Iterator it = children.iterator();
        BasicExpressionSample firstChild = (BasicExpressionSample)it.next();
        if (firstChild == null) {
            throw new BadQueryException(mergeOperator + " needs at least one nested element");
        }
        this.theExecutableCommand = firstChild.theExecutableCommand;
        while (it.hasNext()) {
            BasicExpressionSample exp = (BasicExpressionSample)it.next();
            this.theExecutableCommand = this.theExecutableCommand + " " + mergeOperator + " " + exp.theExecutableCommand;
        }
    }

    public IBasicResultSet execute() throws SearchException {
        BasicResultSetImpl result = new BasicResultSetImpl(true);
        System.out.println("now execute: " + this.theExecutableCommand);
        SubjectNode node = new SubjectNode("/");
        ComparableResourceImpl resource = null;
        IBasicQuery query = this.factory.getQuery();
        try {
            resource = new ComparableResourceImpl(node, query.getSearchToken(), query.getScope(), this.factory.getPropertyProvider());
        }
        catch (SlideException e) {
            throw new SearchException(e);
        }
        result.add(resource);
        return result;
    }
}

