/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidScopeException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.SlideUri;
import org.apache.slide.search.basic.ComparableResourceImpl;
import org.apache.slide.search.basic.ComparableResourcesPool;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.Structure;
import org.apache.slide.structure.StructureException;

public class ComparableResourcesPoolImpl
implements ComparableResourcesPool {
    private Structure structure;
    private Content contentHelper;
    private SlideToken slideToken;
    private QueryScope scope;
    private SearchToken searchToken;
    private int scopeDepth;
    private int maxSlideDepth;
    private boolean partialResult = false;
    private Set pool;
    private SlideUri slideContext;
    protected PropertyProvider propertyProvider = null;

    public ComparableResourcesPoolImpl(SearchToken searchToken, QueryScope scope, PropertyProvider propertyProvider) throws BadQueryException {
        this.structure = searchToken.getStructureHelper();
        this.slideToken = searchToken.getSlideToken();
        this.scope = scope;
        this.propertyProvider = propertyProvider;
        this.contentHelper = searchToken.getContentHelper();
        this.slideContext = searchToken.getSlideContext();
        this.searchToken = searchToken;
        this.scopeDepth = scope.getDepth();
        this.maxSlideDepth = searchToken.getMaxDepth();
        this.createPool();
    }

    public Iterator resourceIterator() {
        return this.pool.iterator();
    }

    public Set getPool() {
        return this.pool;
    }

    private void createPool() throws BadQueryException {
        this.pool = new HashSet();
        String resourceUri = this.searchToken.getSlideContext().getSlidePath(this.scope.getHref());
        ObjectNode resource = null;
        try {
            resource = this.structure.retrieve(this.slideToken, resourceUri);
            this.parseOneObject(resource, 0);
        }
        catch (StructureException e) {
            throw new InvalidScopeException("scope " + resourceUri + " is invalid");
        }
        catch (Exception e) {
            throw new BadQueryException(e.getMessage());
        }
    }

    private void parseOneObject(ObjectNode object, int currentDepth) throws SlideException {
        if (currentDepth > this.scopeDepth) {
            return;
        }
        if (currentDepth > this.maxSlideDepth) {
            this.partialResult = true;
            return;
        }
        Enumeration children = null;
        children = this.structure.getChildren(this.slideToken, object);
        while (children.hasMoreElements()) {
            ObjectNode cur = (ObjectNode)children.nextElement();
            this.parseOneObject(cur, currentDepth + 1);
        }
        ComparableResourceImpl item = new ComparableResourceImpl(object, this.searchToken, this.scope, this.propertyProvider);
        this.pool.add(item);
    }

    public boolean partialResult() {
        return this.partialResult;
    }

    public QueryScope getScope() {
        return this.scope;
    }
}

