/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.BadGatewayException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.QueryScope;
import org.jdom.Element;
import org.jdom.Namespace;

public class BasicQueryScope
implements QueryScope {
    private static Namespace slideNamespace = NodeProperty.NamespaceCache.getNamespace("http://jakarta.apache.org/slide/");
    private String href;
    private int depth;
    private boolean isCollection = true;
    private Set excludedScopes;
    private Set includeSet;
    private Set excludeSet;

    public BasicQueryScope(String href, int depth, Set includeSet, Set excludeSet) {
        this.excludedScopes = new HashSet();
        this.includeSet = new HashSet();
        this.excludeSet = new HashSet();
        this.href = href;
        this.depth = depth;
        this.includeSet = includeSet;
        this.excludeSet = excludeSet;
    }

    /*
     * Unable to fully structure code
     */
    public BasicQueryScope(Element fromElement) throws BadQueryException {
        super();
        this.excludedScopes = new HashSet<E>();
        this.includeSet = new HashSet<E>();
        this.excludeSet = new HashSet<E>();
        this.depth = 0x7FFFFFFF;
        namespace = fromElement.getNamespace();
        name = fromElement.getName();
        if (!namespace.getURI().equals("DAV:") || !name.equals("from")) {
            throw new BadQueryException("expected DAV:from");
        }
        scope = fromElement.getChild("scope", namespace);
        if (scope.getChildren("href", namespace).size() != 1) {
            throw new BadQueryException("exactly one href element must be defined");
        }
        this.href = scope.getChildTextTrim("href", namespace);
        try {
            url = new URL(this.href);
            throw new BadGatewayException(this.href + ": Bad Gateway (no server redirection allowed)");
        }
        catch (MalformedURLException e) {
            depth = scope.getChild("depth", namespace);
            if (depth != null) {
                d = depth.getTextTrim();
                if (d.equals("0")) {
                    this.depth = 0;
                } else if (d.equals("1")) {
                    this.depth = 1;
                }
            }
            it = scope.getChildren("exclude", BasicQueryScope.slideNamespace).iterator();
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            excluded = (Element)it.next();
            href = excluded.getText();
            this.excludedScopes.add(href);
            continue;
        }
lbl34:
        // 1 sources

        it = scope.getChildren("include-lastpathsegment", namespace).iterator();
        while (it.hasNext()) {
            incl = (Element)it.next();
            pattern = incl.getText();
            this.includeSet.add(pattern);
        }
        it = scope.getChildren("exclude-lastpathsegment", namespace).iterator();
        while (it.hasNext()) {
            incl = (Element)it.next();
            pattern = incl.getText();
            this.excludeSet.add(pattern);
        }
    }

    public String getHref() {
        return this.href;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryScope)) {
            return false;
        }
        QueryScope other = (QueryScope)o;
        if (!this.href.equals(other.getHref())) {
            return false;
        }
        return this.depth == other.getDepth();
    }

    public String toString() {
        return this.href + ", depth = " + this.depth;
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
        if (isCollection && !this.href.endsWith("/")) {
            this.href = this.href + "/";
        }
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Set getExcludedScopes() {
        return this.excludedScopes;
    }

    public Set getIncludeSet() {
        return this.includeSet;
    }

    public Set getExcludeSet() {
        return this.excludeSet;
    }
}

