/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.Scope;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideRuntimeException;
import org.apache.slide.common.Uri;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidScopeException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.SlideUri;
import org.apache.slide.search.basic.BasicQuery;
import org.apache.slide.search.basic.BasicQueryImpl;
import org.apache.slide.search.basic.BasicQueryScope;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.QueryTree;
import org.apache.slide.store.AbstractStore;
import org.jdom.Element;

public class BasicQueryEnvelope
extends SearchQuery
implements IBasicQuery {
    private BasicQueryImpl topLevelQuery;
    private QueryScope topLevelQueryScope;
    private Map subQueries = new HashMap();
    private QueryTree queryTree;
    private int queryDepth;
    private SlideUri slideUri;
    private SearchToken token;

    public BasicQueryEnvelope(SearchToken token, QueryScope queryScope) throws InvalidScopeException {
        this.token = token;
        Namespace namespace = token.getNamespace();
        Enumeration stores = namespace.enumerateScopes();
        this.slideUri = token.getSlideContext();
        this.topLevelQueryScope = queryScope;
        String slideScope = this.slideUri.getSlidePath(queryScope.getHref());
        Scope topScope = new Scope(slideScope);
        Set ex = queryScope.getExcludedScopes();
        int size = ex.size();
        Scope[] excludedScopes = new Scope[size];
        Iterator it = ex.iterator();
        int i = 0;
        while (i < size) {
            String href = (String)it.next();
            excludedScopes[i] = new Scope(this.slideUri.getSlidePath(href));
            ++i;
        }
        this.queryTree = new QueryTree(stores, topScope, excludedScopes);
        it = this.queryTree.iterator();
        while (it.hasNext()) {
            Scope sScope = (Scope)it.next();
            BasicQueryImpl query = this.createSubQuery(namespace, sScope.toString(), token);
            this.subQueries.put(sScope, query);
        }
        this.topLevelQuery = (BasicQueryImpl)this.subQueries.get(topScope);
    }

    public void parseQueryElement(Element basicSearchElement, PropertyProvider propertyProvider) throws BadQueryException {
        this.queryDepth = Math.min(this.topLevelQueryScope.getDepth(), this.token.getMaxDepth());
        Iterator<Object> it = this.subQueries.keySet().iterator();
        HashSet<Scope> scopesToRemove = new HashSet<Scope>();
        while (it.hasNext()) {
            Scope scope = (Scope)it.next();
            QueryScope subQueryScope = this.calculateSubQueryScope(scope);
            if (subQueryScope.getDepth() >= 0) {
                BasicQueryImpl query = (BasicQueryImpl)this.subQueries.get(scope);
                query.parseQueryElement(basicSearchElement, propertyProvider, subQueryScope);
                continue;
            }
            scopesToRemove.add(scope);
        }
        it = scopesToRemove.iterator();
        while (it.hasNext()) {
            this.subQueries.remove(it.next());
        }
    }

    public SearchQueryResult execute() throws ServiceAccessException {
        Iterator it = this.subQueries.keySet().iterator();
        SearchQueryResult result = null;
        result = this.topLevelQuery.orderBy != null ? new SearchQueryResult(this.topLevelQuery.orderBy.getComparator()) : new SearchQueryResult();
        while (it.hasNext()) {
            Scope scope = (Scope)it.next();
            BasicQuery query = (BasicQuery)this.subQueries.get(scope);
            query.setScope(this.calculateSubQueryScope(scope));
            SearchQueryResult subResult = query.execute();
            result.add(subResult);
            if (subResult.getStatus() == 0) continue;
            result.setStatus(subResult.getStatus());
            result.setDescription(subResult.getDescription());
        }
        return result;
    }

    private QueryScope calculateSubQueryScope(Scope scope) {
        int relDepth = this.queryTree.relativeDepth(scope);
        int subQueryDepth = this.queryTree.hasChildren(scope) ? 1 : (this.queryDepth == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.queryDepth - relDepth);
        String contextPath = this.slideUri.getContextPath(scope.toString());
        Set inclSet = this.topLevelQueryScope.getIncludeSet();
        Set exclSet = this.topLevelQueryScope.getExcludeSet();
        BasicQueryScope queryScope = new BasicQueryScope(contextPath, subQueryDepth, inclSet, exclSet);
        return queryScope;
    }

    private int getDepthOfHRef(String href) {
        StringTokenizer st = new StringTokenizer(href, "/");
        return st.countTokens();
    }

    private BasicQueryImpl createSubQuery(Namespace namespace, String slideScope, SearchToken token) throws SlideRuntimeException {
        BasicQueryImpl query = null;
        Uri uri = namespace.getUri(token.getSlideToken(), slideScope);
        AbstractStore store = (AbstractStore)uri.getStore();
        String className = (String)store.getParameter("basicQueryClass");
        if (className != null) {
            try {
                Class<?> queryClass = Class.forName(className);
                query = (BasicQueryImpl)queryClass.newInstance();
                query.init(token);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SlideRuntimeException(e.getMessage());
            }
        } else {
            query = new BasicQueryImpl(token);
        }
        return query;
    }

    public AbstractStore getStore() {
        return this.topLevelQuery.getStore();
    }

    public QueryScope getScope() {
        return this.topLevelQueryScope;
    }

    public PropertyProvider getPropertyProvider() {
        return this.topLevelQuery.getPropertyProvider();
    }

    public boolean isLimitDefined() {
        return this.topLevelQuery.isLimitDefined();
    }

    public int getLimit() {
        return this.topLevelQuery.getLimit();
    }

    public IBasicExpression getExpression() {
        return this.topLevelQuery.getExpression();
    }

    public RequestedProperties requestedProperties() {
        return this.topLevelQuery.requestedProperties;
    }

    public String getSlidePath() throws InvalidScopeException {
        return this.topLevelQuery.getSlidePath();
    }

    public SearchToken getSearchToken() {
        return this.topLevelQuery.getSearchToken();
    }

    public IBasicExpressionFactory getExpressionFactory() {
        return null;
    }

    public void init(SearchToken token) {
        this.token = token;
    }
}

