/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.util.Messages;

public final class NodeRevisionNumber
implements Serializable,
Cloneable {
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final NodeRevisionNumber HIDDEN_0_0 = new NodeRevisionNumber(0, 0);
    private int[] number;
    private String cachedToString;
    static /* synthetic */ Class class$org$apache$slide$content$NodeRevisionNumber;

    public NodeRevisionNumber() {
        this.number = new int[2];
        this.number[0] = 1;
        this.number[1] = 0;
    }

    public NodeRevisionNumber(int major, int minor) {
        this.number = new int[2];
        this.number[0] = major;
        this.number[1] = minor;
    }

    public NodeRevisionNumber(String revisionNumberStr) {
        this.parseString(revisionNumberStr);
    }

    public NodeRevisionNumber(NodeRevisionNumber revisionNumber) {
        this(revisionNumber, false);
    }

    public NodeRevisionNumber(NodeRevisionNumber revisionNumber, boolean createBranch) {
        if (revisionNumber != null) {
            if (createBranch) {
                this.parseString(revisionNumber.toString() + ".1");
            } else {
                this.parseString(revisionNumber.toString());
                this.next();
            }
        } else {
            this.number = new int[2];
            this.number[0] = 1;
            this.number[1] = 0;
        }
    }

    public int getMajor() {
        return this.number[0];
    }

    public int getMinor() {
        return this.number[1];
    }

    public int getNumber(int pos) {
        return this.number[pos];
    }

    public int getNbDigits() {
        return this.number.length;
    }

    private void parseString(String revisionNumberStr) {
        StringTokenizer tokenizer = new StringTokenizer(revisionNumberStr, ".");
        int nbDigits = tokenizer.countTokens();
        if (nbDigits > 0) {
            this.number = new int[nbDigits];
            int i = 0;
            while (i < nbDigits) {
                this.number[i] = new Integer(tokenizer.nextToken());
                ++i;
            }
            this.cachedToString = null;
        } else {
            this.number = new int[2];
            this.number[0] = 1;
            this.number[1] = 0;
            this.cachedToString = null;
        }
    }

    private void next() {
        if (this.number.length > 0) {
            int n = this.number.length - 1;
            this.number[n] = this.number[n] + 1;
            this.cachedToString = null;
        }
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        int count = this.number.length;
        if (count == 2) {
            this.cachedToString = this.number[0] + "." + this.number[1];
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(this.number[0]);
            int i = 1;
            while (i < count) {
                buf.append('.').append(this.number[i]);
                ++i;
            }
            this.cachedToString = buf.toString();
        }
        return this.cachedToString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodeRevisionNumber) {
            result = this.toString().equals(obj.toString());
        }
        return result;
    }

    NodeRevisionNumber cloneObject() {
        NodeRevisionNumber result = null;
        try {
            result = (NodeRevisionNumber)super.clone();
        }
        catch (CloneNotSupportedException e) {}
        return result;
    }

    public void validate() {
        if (this.number == null) {
            throw new ObjectValidationFailedException(Messages.message((class$org$apache$slide$content$NodeRevisionNumber == null ? (class$org$apache$slide$content$NodeRevisionNumber = NodeRevisionNumber.class$("org.apache.slide.content.NodeRevisionNumber")) : class$org$apache$slide$content$NodeRevisionNumber).getName() + ".nullNumber"));
        }
        if (this.number.length < 2) {
            throw new ObjectValidationFailedException(Messages.message((class$org$apache$slide$content$NodeRevisionNumber == null ? (class$org$apache$slide$content$NodeRevisionNumber = NodeRevisionNumber.class$("org.apache.slide.content.NodeRevisionNumber")) : class$org$apache$slide$content$NodeRevisionNumber).getName() + ".invalidNumber"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

