/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CompilerConfiguration {
    private String outputLocation;
    private List classpathEntries = new LinkedList();
    private List sourceLocations = new LinkedList();
    private Set includes = new HashSet();
    private Set excludes = new HashSet();
    private Map compilerOptions = new TreeMap();
    private boolean debug = false;
    private Set sourceFiles = new HashSet();
    private boolean noWarn;

    public void setSourceFiles(Set sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public Set getSourceFiles() {
        return this.sourceFiles;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void addClasspathEntry(String classpathEntry) {
        this.classpathEntries.add(classpathEntry);
    }

    public void setClasspathEntries(List classpathEntries) {
        this.classpathEntries = new LinkedList(classpathEntries);
    }

    public List getClasspathEntries() {
        return Collections.unmodifiableList(this.classpathEntries);
    }

    public void addSourceLocation(String sourceLocation) {
        this.sourceLocations.add(sourceLocation);
    }

    public void setSourceLocations(List sourceLocations) {
        this.sourceLocations = new LinkedList(sourceLocations);
    }

    public List getSourceLocations() {
        return Collections.unmodifiableList(this.sourceLocations);
    }

    public void addInclude(String include) {
        this.includes.add(include);
    }

    public void setIncludes(Set includes) {
        this.includes = new HashSet(includes);
    }

    public Set getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void setExcludes(Set excludes) {
        this.excludes = new HashSet(excludes);
    }

    public Set getExcludes() {
        return Collections.unmodifiableSet(this.excludes);
    }

    public void addCompilerOption(String optionName, String optionValue) {
        this.compilerOptions.put(optionName, optionValue);
    }

    public void setCompilerOptions(Map compilerOptions) {
        this.compilerOptions = new TreeMap(compilerOptions);
    }

    public Map getCompilerOptions() {
        return Collections.unmodifiableMap(this.compilerOptions);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setNoWarn(boolean noWarn) {
        this.noWarn = noWarn;
    }

    public boolean isNoWarn() {
        return this.noWarn;
    }
}

