/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import pl.project13.maven.git.ReplacementProperty;
import pl.project13.maven.git.log.LoggerBridge;

public class PropertiesReplacer {
    private final LoggerBridge log;

    public PropertiesReplacer(LoggerBridge log) {
        this.log = log;
    }

    public void performReplacement(Properties properties, List<ReplacementProperty> replacementProperties) {
        if (replacementProperties != null && properties != null) {
            for (ReplacementProperty replacementProperty : replacementProperties) {
                String propertyKey = replacementProperty.getProperty();
                if (propertyKey == null) {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String key = (String)entry.getKey();
                        String content = (String)entry.getValue();
                        String result = this.performReplacement(replacementProperty, content);
                        entry.setValue(result);
                        this.log.info("apply replace on property " + key + ": original value '" + content + "' with '" + result + "'");
                    }
                    continue;
                }
                String content = properties.getProperty(propertyKey);
                String result = this.performReplacement(replacementProperty, content);
                properties.setProperty(propertyKey, result);
                this.log.info("apply replace on property " + propertyKey + ": original value '" + content + "' with '" + result + "'");
            }
        }
    }

    private String performReplacement(ReplacementProperty replacementProperty, String content) {
        String result = content;
        if (replacementProperty != null) {
            result = replacementProperty.isRegex() ? this.replaceRegex(content, replacementProperty.getToken(), replacementProperty.getValue()) : this.replaceNonRegex(content, replacementProperty.getToken(), replacementProperty.getValue());
        }
        return result;
    }

    private String replaceRegex(String content, String token, String value) {
        if (token == null || value == null) {
            this.log.error("found replacementProperty without required token or value.");
            return content;
        }
        Pattern compiledPattern = Pattern.compile(token);
        return compiledPattern.matcher(content).replaceAll(value);
    }

    private String replaceNonRegex(String content, String token, String value) {
        if (token == null || value == null) {
            this.log.error("found replacementProperty without required token or value.");
            return content;
        }
        return content.replace(token, value);
    }
}

