/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.file;

import java.io.BufferedReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import pl.jalokim.utils.file.FileUtils;

public class FileCursor
implements Iterator<String> {
    private final BufferedReader bufferedReader = FileUtils.catchIoExAndReturn(() -> Files.newBufferedReader(Paths.get(filePath, new String[0]), charset));
    private String currentLine;
    private String nextLine = FileUtils.catchIoExAndReturn(this.bufferedReader::readLine);
    private long currentLineNumber;

    public FileCursor(String filePath) {
        this(filePath, StandardCharsets.UTF_8);
    }

    public FileCursor(String filePath, Charset charset) {
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    public Long getLineNumber() {
        return this.currentLineNumber;
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public String next() {
        this.currentLine = this.nextLine;
        this.nextLine = FileUtils.catchIoExAndReturn(this.bufferedReader::readLine);
        ++this.currentLineNumber;
        return this.currentLine;
    }

    public void close() {
        FileUtils.catchIoExAndReturn(() -> {
            this.bufferedReader.close();
            return null;
        });
    }
}

