/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.reflection.MetadataReflectionUtils;
import pl.jalokim.utils.reflection.ReflectionOperationException;
import pl.jalokim.utils.reflection.TypeWrapperBuilder;
import pl.jalokim.utils.string.StringUtils;

public class TypeMetadata {
    static final TypeMetadata NATIVE_OBJECT_META = TypeWrapperBuilder.buildFromClass(Object.class);
    private static final String ARRAY_MARK = "[]";
    private final List<TypeMetadata> genericTypes;
    private final Class<?> rawType;
    private final Map<String, TypeMetadata> genericTypesByRawLabel;
    private final TypeMetadata parentTypeMetadata;

    TypeMetadata(Class<?> rawType, List<TypeMetadata> genericTypes) {
        ArrayList tempGenerics = CollectionUtils.isEmpty(genericTypes) ? new ArrayList() : genericTypes;
        this.rawType = rawType;
        List<Type> parametrizedTypesForClass = MetadataReflectionUtils.getParametrizedRawTypes(rawType);
        if (CollectionUtils.isEmpty(parametrizedTypesForClass) && CollectionUtils.isNotEmpty(tempGenerics) && !rawType.isArray()) {
            AtomicInteger index2 = new AtomicInteger();
            throw new ReflectionOperationException(String.format("raw class: %s doesn't have any parametrized types, but tried put generic types:%n%s", rawType.getCanonicalName(), StringUtils.concatElementsAsLines(tempGenerics, text -> StringUtils.concatObjects(index2.getAndIncrement(), ".", " ", text))));
        }
        ConcurrentHashMap tempMap = new ConcurrentHashMap();
        Elements.elements(parametrizedTypesForClass).forEach((index, type) -> {
            if (tempGenerics.size() == index.intValue()) {
                TypeWrapperBuilder.buildFromClass(Object.class);
                tempGenerics.add((int)index, NATIVE_OBJECT_META);
                tempMap.put(type.getTypeName(), NATIVE_OBJECT_META);
            } else {
                tempMap.put(type.getTypeName(), tempGenerics.get((int)index));
            }
        });
        this.genericTypes = Collections.unmodifiableList(tempGenerics);
        this.genericTypesByRawLabel = Collections.unmodifiableMap(tempMap);
        this.parentTypeMetadata = this.buildParentMetadata(this, rawType, this.genericTypesByRawLabel);
    }

    private TypeMetadata buildParentMetadata(TypeMetadata childMetadata, Class<?> childClass, Map<String, TypeMetadata> childGenericTypesByRawLabel) {
        Class<?> parentClass = childClass.getSuperclass();
        if (parentClass == null) {
            return null;
        }
        if (parentClass == Object.class || childMetadata.getRawType().isEnum() || childMetadata.isArrayType()) {
            return null;
        }
        Type genericSuperclass = childClass.getGenericSuperclass();
        if (genericSuperclass.equals(parentClass)) {
            return new TypeMetadata(parentClass, null);
        }
        List<TypeMetadata> types = Elements.elements(((ParameterizedType)genericSuperclass).getActualTypeArguments()).map(type -> this.mapFromType((Type)type, childGenericTypesByRawLabel)).asList();
        return new TypeMetadata(parentClass, types);
    }

    private TypeMetadata mapFromType(Type type, Map<String, TypeMetadata> childGenericTypesByRawLabel) {
        if (type instanceof Class) {
            return TypeWrapperBuilder.buildFromClass((Class)type);
        }
        TypeMetadata typeMetadata = childGenericTypesByRawLabel.get(type.getTypeName());
        if (typeMetadata == null) {
            typeMetadata = TypeWrapperBuilder.buildFromType(type);
        }
        return typeMetadata;
    }

    public boolean hasGenericTypes() {
        return CollectionUtils.isNotEmpty(this.genericTypes);
    }

    public String getCanonicalName() {
        return this.rawType.getCanonicalName();
    }

    public TypeMetadata getTypeMetadataForField(Class<?> fieldOwner, String typeName) {
        for (TypeMetadata currentMeta = this; currentMeta != null; currentMeta = currentMeta.getParentTypeMetadata()) {
            TypeMetadata typeMetadataForGenericLabel;
            if (!currentMeta.getRawType().equals(fieldOwner) || (typeMetadataForGenericLabel = currentMeta.getByGenericLabel(typeName)) == null) continue;
            return typeMetadataForGenericLabel;
        }
        throw new ReflectionOperationException(String.format("Cannot find raw type: '%s' for class: '%s' in current context: %s ", typeName, fieldOwner.getCanonicalName(), this.toString()));
    }

    public TypeMetadata getByGenericLabel(String genericLabel) {
        return this.genericTypesByRawLabel.get(genericLabel);
    }

    public boolean isEnumType() {
        return this.getRawType().isEnum();
    }

    public boolean isArrayType() {
        return this.getRawType().isArray();
    }

    public boolean isMapType() {
        return MetadataReflectionUtils.isMapType(this.getRawType());
    }

    public boolean isHavingElementsType() {
        return this.isArrayType() || MetadataReflectionUtils.isHavingElementsType(this.getRawType());
    }

    public boolean isSimpleType() {
        return MetadataReflectionUtils.isSimpleType(this.getRawType());
    }

    public boolean hasParent() {
        return this.parentTypeMetadata != null;
    }

    public TypeMetadata getMetaForField(String fieldName) {
        Field field = MetadataReflectionUtils.getField(this.rawType, fieldName);
        if (field.getGenericType() instanceof Class) {
            return TypeWrapperBuilder.buildFromField(field);
        }
        return TypeWrapperBuilder.buildFromType(field.getGenericType(), field, this);
    }

    public TypeMetadata getGenericType(int index) {
        if (this.hasGenericTypes() && this.getGenericTypes().size() - 1 >= index) {
            return this.genericTypes.get(index);
        }
        throw new ReflectionOperationException("Cannot find generic type at index: " + index);
    }

    public String toString() {
        if (this.isArrayType()) {
            return StringUtils.concat(StringUtils.concatElements(this.getGenericTypes()), ARRAY_MARK);
        }
        String genericsPart = "";
        if (this.hasGenericTypes()) {
            genericsPart = StringUtils.concatElements("<", this.getGenericTypes(), TypeMetadata::toString, ",", ">");
        }
        String classType = this.rawType.getSimpleName();
        if (this.hasParent()) {
            return StringUtils.concat("{", classType, " extends ", this.parentTypeMetadata.toString(), genericsPart, "}");
        }
        return StringUtils.concat(classType, genericsPart);
    }

    @Generated
    public List<TypeMetadata> getGenericTypes() {
        return this.genericTypes;
    }

    @Generated
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Generated
    public Map<String, TypeMetadata> getGenericTypesByRawLabel() {
        return this.genericTypesByRawLabel;
    }

    @Generated
    public TypeMetadata getParentTypeMetadata() {
        return this.parentTypeMetadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeMetadata)) {
            return false;
        }
        TypeMetadata other = (TypeMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TypeMetadata> this$genericTypes = this.getGenericTypes();
        List<TypeMetadata> other$genericTypes = other.getGenericTypes();
        if (this$genericTypes == null ? other$genericTypes != null : !((Object)this$genericTypes).equals(other$genericTypes)) {
            return false;
        }
        Class<?> this$rawType = this.getRawType();
        Class<?> other$rawType = other.getRawType();
        if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
            return false;
        }
        Map<String, TypeMetadata> this$genericTypesByRawLabel = this.getGenericTypesByRawLabel();
        Map<String, TypeMetadata> other$genericTypesByRawLabel = other.getGenericTypesByRawLabel();
        if (this$genericTypesByRawLabel == null ? other$genericTypesByRawLabel != null : !((Object)this$genericTypesByRawLabel).equals(other$genericTypesByRawLabel)) {
            return false;
        }
        TypeMetadata this$parentTypeMetadata = this.getParentTypeMetadata();
        TypeMetadata other$parentTypeMetadata = other.getParentTypeMetadata();
        return !(this$parentTypeMetadata == null ? other$parentTypeMetadata != null : !((Object)this$parentTypeMetadata).equals(other$parentTypeMetadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TypeMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TypeMetadata> $genericTypes = this.getGenericTypes();
        result = result * 59 + ($genericTypes == null ? 43 : ((Object)$genericTypes).hashCode());
        Class<?> $rawType = this.getRawType();
        result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
        Map<String, TypeMetadata> $genericTypesByRawLabel = this.getGenericTypesByRawLabel();
        result = result * 59 + ($genericTypesByRawLabel == null ? 43 : ((Object)$genericTypesByRawLabel).hashCode());
        TypeMetadata $parentTypeMetadata = this.getParentTypeMetadata();
        result = result * 59 + ($parentTypeMetadata == null ? 43 : ((Object)$parentTypeMetadata).hashCode());
        return result;
    }
}

