/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.file;

import java.io.BufferedWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import pl.jalokim.utils.file.FileException;
import pl.jalokim.utils.file.FileUtils;

public class FileWriter
implements AutoCloseable,
Flushable {
    private final BufferedWriter bufferedWriter;

    public FileWriter(String filePath) {
        try {
            OutputStream fos = Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(fos, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new FileException(e);
        }
    }

    public void append(CharSequence text) {
        FileUtils.catchIoExAndReturn(() -> this.bufferedWriter.append(text));
    }

    public void appendAndNextLine(CharSequence text) {
        FileUtils.catchIoEx(() -> {
            this.bufferedWriter.append(text);
            this.bufferedWriter.newLine();
        });
    }

    public void appendNextLine() {
        FileUtils.catchIoEx(this.bufferedWriter::newLine);
    }

    @Override
    public void close() {
        FileUtils.catchIoEx(this.bufferedWriter::close);
    }

    @Override
    public void flush() {
        FileUtils.catchIoEx(this.bufferedWriter::flush);
    }
}

