/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import pl.jalokim.utils.collection.Elements;
import pl.jalokim.utils.reflection.ClassNameFixer;
import pl.jalokim.utils.reflection.MetadataReflectionUtils;
import pl.jalokim.utils.reflection.ReflectionOperationException;
import pl.jalokim.utils.reflection.TypeMetadata;
import pl.jalokim.utils.reflection.UnresolvedRealClassException;

final class TypeWrapperBuilder {
    private static final CharsParser CHARS_PARSER = new CharsParser();

    private TypeWrapperBuilder() {
    }

    static TypeMetadata buildFromClass(Class<?> someClass) {
        List<Type> genericsTypes = MetadataReflectionUtils.getParametrizedRawTypes(someClass);
        if (genericsTypes.isEmpty()) {
            return new TypeMetadata(someClass, null);
        }
        return new TypeMetadata(someClass, Elements.elements(genericsTypes).map(type -> TypeMetadata.NATIVE_OBJECT_META).asList());
    }

    static TypeMetadata buildFromField(Field field) {
        if (field.getType().isPrimitive()) {
            return TypeWrapperBuilder.buildFromClass(field.getType());
        }
        if (field.getType().isArray()) {
            return TypeWrapperBuilder.buildForArrayField(field);
        }
        return TypeWrapperBuilder.buildFromType(field.getGenericType());
    }

    static TypeMetadata buildForArrayField(Field arrayField) {
        return TypeWrapperBuilder.buildFromType(arrayField.getGenericType());
    }

    static TypeMetadata buildFromType(Type type) {
        return TypeWrapperBuilder.buildFromType(type, null, null);
    }

    static TypeMetadata buildFromType(Type type, Field originalField, TypeMetadata currentContext) {
        String fullName = type.getTypeName();
        char[] arrayOfChars = fullName.toCharArray();
        InnerTypeMetaData current = new InnerTypeMetaData(originalField, currentContext);
        for (char nextChar : arrayOfChars) {
            current = CHARS_PARSER.parse(nextChar, current);
        }
        return TypeWrapperBuilder.buildFromInnerTypeMetaData(current);
    }

    static TypeMetadata buildFromInnerTypeMetaData(InnerTypeMetaData typeWrapper) {
        Class<?> realClass;
        String typeName = typeWrapper.getClassName();
        if ("?".equals(typeName)) {
            return new TypeMetadata(Object.class, null);
        }
        if (typeName.matches("^\\?extends(.)+")) {
            typeName = typeName.replace("?extends", "");
        } else if (typeName.matches("^\\?super(.)+")) {
            return new TypeMetadata(Object.class, null);
        }
        if (TypeWrapperBuilder.hasArraySignature(typeName)) {
            return TypeWrapperBuilder.buildFromArrayClass(typeWrapper, typeName);
        }
        try {
            realClass = TypeWrapperBuilder.getFixedClassName(typeName);
        }
        catch (ReflectionOperationException exception) {
            if (typeWrapper.getAvailableContext() != null) {
                Field originalField = typeWrapper.getOriginalField();
                Class<?> fieldOwner = originalField.getDeclaringClass();
                TypeMetadata availableContext = typeWrapper.getAvailableContext();
                return availableContext.getTypeMetadataForField(fieldOwner, typeName);
            }
            throw new UnresolvedRealClassException(exception);
        }
        return new TypeMetadata(realClass, TypeWrapperBuilder.buildGenericsList(typeWrapper.getGenericTypes()));
    }

    private static TypeMetadata buildFromArrayClass(InnerTypeMetaData typeWrapper, String currentClassName) {
        Class<?> rawClassForArray = TypeWrapperBuilder.getFixedClassName(currentClassName);
        String typeOfStoredInArray = currentClassName.replaceAll("(\\[])$", "");
        TypeMetadata genericDataOfArray = TypeWrapperBuilder.hasArraySignature(typeOfStoredInArray) ? TypeWrapperBuilder.buildFromArrayClass(typeWrapper, typeOfStoredInArray) : new TypeMetadata(TypeWrapperBuilder.getFixedClassName(typeOfStoredInArray), TypeWrapperBuilder.buildGenericsList(typeWrapper.getGenericTypes()));
        return new TypeMetadata(rawClassForArray, Collections.singletonList(genericDataOfArray));
    }

    private static boolean hasArraySignature(String className) {
        return className.matches(".*\\[]");
    }

    static List<TypeMetadata> buildGenericsList(List<InnerTypeMetaData> generics) {
        return Elements.elements(generics).map(TypeWrapperBuilder::buildFromInnerTypeMetaData).filter(Objects::nonNull).asList();
    }

    private static Class<?> getFixedClassName(String className) {
        return MetadataReflectionUtils.getClassForName(ClassNameFixer.fixClassName(className));
    }

    private static class CharsParser {
        private static final char START_GENERIC_CHAR = '<';
        private static final char COMMA_CHAR = ',';
        private static final char END_GENERIC_CHAR = '>';
        private static final char SPACE_CHAR = ' ';

        private CharsParser() {
        }

        InnerTypeMetaData parse(char nextChar, InnerTypeMetaData currentMetadata) {
            if (nextChar == '<') {
                InnerTypeMetaData child = new InnerTypeMetaData(currentMetadata.getOriginalField(), currentMetadata.getAvailableContext());
                currentMetadata.addChild(child);
                child.setParent(currentMetadata);
                return child;
            }
            if (nextChar == ',') {
                InnerTypeMetaData parent = currentMetadata.getParent();
                InnerTypeMetaData child = new InnerTypeMetaData(currentMetadata.getOriginalField(), currentMetadata.getAvailableContext());
                parent.addChild(child);
                child.setParent(parent);
                return child;
            }
            if (nextChar == '>') {
                return currentMetadata.getParent();
            }
            if (nextChar == ' ') {
                return currentMetadata;
            }
            currentMetadata.appendToClassName(nextChar);
            return currentMetadata;
        }
    }

    static class InnerTypeMetaData {
        private InnerTypeMetaData parent;
        private final StringBuilder classNameBuilder = new StringBuilder();
        private final List<InnerTypeMetaData> genericTypes = new ArrayList<InnerTypeMetaData>();
        private final Field originalField;
        private final TypeMetadata availableContext;

        void addChild(InnerTypeMetaData innerTypeMetaData) {
            this.genericTypes.add(innerTypeMetaData);
        }

        void appendToClassName(char nextChar) {
            this.classNameBuilder.append(nextChar);
        }

        String getClassName() {
            return this.classNameBuilder.toString();
        }

        public String toString() {
            String parentText = this.parent == null ? "null" : this.parent.getClassName();
            return "InnerTypeMetaData{parent=" + parentText + ", className=" + this.getClassName() + ", genericTypes=" + this.genericTypes + '}';
        }

        @Generated
        public InnerTypeMetaData(Field originalField, TypeMetadata availableContext) {
            this.originalField = originalField;
            this.availableContext = availableContext;
        }

        @Generated
        public InnerTypeMetaData getParent() {
            return this.parent;
        }

        @Generated
        public StringBuilder getClassNameBuilder() {
            return this.classNameBuilder;
        }

        @Generated
        public List<InnerTypeMetaData> getGenericTypes() {
            return this.genericTypes;
        }

        @Generated
        public Field getOriginalField() {
            return this.originalField;
        }

        @Generated
        public TypeMetadata getAvailableContext() {
            return this.availableContext;
        }

        @Generated
        public void setParent(InnerTypeMetaData parent) {
            this.parent = parent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InnerTypeMetaData)) {
                return false;
            }
            InnerTypeMetaData other = (InnerTypeMetaData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InnerTypeMetaData this$parent = this.getParent();
            InnerTypeMetaData other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            StringBuilder this$classNameBuilder = this.getClassNameBuilder();
            StringBuilder other$classNameBuilder = other.getClassNameBuilder();
            if (this$classNameBuilder == null ? other$classNameBuilder != null : !this$classNameBuilder.equals(other$classNameBuilder)) {
                return false;
            }
            List<InnerTypeMetaData> this$genericTypes = this.getGenericTypes();
            List<InnerTypeMetaData> other$genericTypes = other.getGenericTypes();
            if (this$genericTypes == null ? other$genericTypes != null : !((Object)this$genericTypes).equals(other$genericTypes)) {
                return false;
            }
            Field this$originalField = this.getOriginalField();
            Field other$originalField = other.getOriginalField();
            if (this$originalField == null ? other$originalField != null : !((Object)this$originalField).equals(other$originalField)) {
                return false;
            }
            TypeMetadata this$availableContext = this.getAvailableContext();
            TypeMetadata other$availableContext = other.getAvailableContext();
            return !(this$availableContext == null ? other$availableContext != null : !((Object)this$availableContext).equals(other$availableContext));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InnerTypeMetaData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InnerTypeMetaData $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            StringBuilder $classNameBuilder = this.getClassNameBuilder();
            result = result * 59 + ($classNameBuilder == null ? 43 : $classNameBuilder.hashCode());
            List<InnerTypeMetaData> $genericTypes = this.getGenericTypes();
            result = result * 59 + ($genericTypes == null ? 43 : ((Object)$genericTypes).hashCode());
            Field $originalField = this.getOriginalField();
            result = result * 59 + ($originalField == null ? 43 : ((Object)$originalField).hashCode());
            TypeMetadata $availableContext = this.getAvailableContext();
            result = result * 59 + ($availableContext == null ? 43 : ((Object)$availableContext).hashCode());
            return result;
        }
    }
}

