/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.random;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import pl.jalokim.utils.random.RandomException;
import pl.jalokim.utils.random.RandomUtils;

public class RandomUtilImpl {
    private final Random random;

    public RandomUtilImpl() {
        this.random = new SecureRandom();
    }

    public RandomUtilImpl(Random random) {
        this.random = random;
    }

    public Integer randomInRangeImpl(int min, int max) {
        if (max < min) {
            throw new RandomException("Max: " + max + " should be greater than or equals with min: " + min);
        }
        return this.random.nextInt(max - min + 1) + min;
    }

    public <T> T randomElementImpl(Collection<T> elements) {
        if (elements.isEmpty()) {
            throw new RandomException("Cannot get random element from empty list: " + elements);
        }
        ArrayList<T> asList = new ArrayList<T>(elements);
        return (T)asList.get(this.randomInRangeImpl(0, elements.size() - 1));
    }

    public boolean randomTrue() {
        int number = this.randomInRangeImpl(0, 1);
        return number == 1;
    }

    public boolean randomTrueWithProbability(int probabilityOfTrueInPercent) {
        return RandomUtils.randomElement(this.generateProbabilityArray(probabilityOfTrueInPercent));
    }

    protected List<Boolean> generateProbabilityArray(int probabilityOfTrueInPercent) {
        ArrayList<Boolean> probabilityOfTrueList = new ArrayList<Boolean>();
        boolean defaultValue = probabilityOfTrueInPercent <= 50;
        probabilityOfTrueInPercent = probabilityOfTrueInPercent <= 50 ? probabilityOfTrueInPercent : 100 - probabilityOfTrueInPercent;
        int size = 100 / probabilityOfTrueInPercent;
        for (int i = 0; i < size; ++i) {
            probabilityOfTrueList.add(!defaultValue);
        }
        int indexToChange = RandomUtils.randomIndex(probabilityOfTrueList);
        probabilityOfTrueList.set(indexToChange, defaultValue);
        return probabilityOfTrueList;
    }
}

