/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.util;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.grizzlysoftware.util.ResponseStatusException;
import retrofit2.Call;
import retrofit2.Response;

public class RetrofitCallExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetrofitCallExecutor.class);
    protected Class target;

    public RetrofitCallExecutor(Class target) {
        this.target = Objects.requireNonNull(target);
    }

    public <T> T execOrThrow(Call<T> call) {
        return (T)this.executeOrThrow(call).body();
    }

    public <T> Response<T> executeOrThrow(Call<T> call) {
        try {
            Response response = Objects.requireNonNull(call).execute();
            if (!response.isSuccessful()) {
                throw new ResponseStatusException(response.code(), String.format("Unable to invoke external service: %s, response status %s, response message: %s, response headers: %s", this.target.getSimpleName(), response.code(), response.message(), Optional.ofNullable(response.headers()).map(e -> e.toString()).orElse("[]")));
            }
            return response;
        }
        catch (IOException e2) {
            LOGGER.error("Exception occured while sending request: {}", (Object)e2.getMessage());
            throw new ResponseStatusException(503);
        }
    }
}

