/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.util;

import java.io.IOException;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;
import pl.grizzlysoftware.dotykacka.util.AccessTokenExtractor;
import pl.grizzlysoftware.util.TokenProvider;

public class OkHttpAccessTokenAuthenticator
implements Authenticator,
Interceptor {
    protected TokenProvider tokenProvider;
    protected AccessTokenExtractor accessTokenExtractor;

    public OkHttpAccessTokenAuthenticator(TokenProvider tokenProvider, AccessTokenExtractor accessTokenExtractor) {
        this.tokenProvider = Objects.requireNonNull(tokenProvider);
        this.accessTokenExtractor = Objects.requireNonNull(accessTokenExtractor);
    }

    public Request authenticate(Route route, Response response) {
        Object accessToken = this.accessTokenExtractor.apply(this.tokenProvider.acquireToken());
        return response.request().newBuilder().header("Authorization", "Bearer " + accessToken).build();
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Object accessToken = this.accessTokenExtractor.apply(this.tokenProvider.acquireToken());
        Request request = chain.request().newBuilder().header("Authorization", "Bearer " + accessToken).build();
        return chain.proceed(request);
    }
}

