/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1;

import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.oauth.OAuthApiToken;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.BranchService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.CategoryService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.CustomerService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.EmployeeService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.OAuthService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.ProductService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.SupplierService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.TableSeatService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.TagService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.WarehouseService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.MoneylogService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.OrderOpenService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.OrderService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.ReceiptService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.SalesService;
import pl.grizzlysoftware.dotykacka.client.v1.facade.BranchServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.CategoryServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.CustomerServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.EmployeeServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.OAuthServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.ProductServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.SalesServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.SupplierServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.TableSeatServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.TagServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.WarehouseServiceFacade;
import pl.grizzlysoftware.dotykacka.model.Configuration;
import pl.grizzlysoftware.dotykacka.util.AccessTokenProvider;
import pl.grizzlysoftware.dotykacka.util.ApiTokenProvider;
import pl.grizzlysoftware.dotykacka.util.OAuthRequestInterceptor;
import pl.grizzlysoftware.util.OkHttpClientUtils;
import pl.grizzlysoftware.util.OkHttpLoggingInterceptor;
import pl.grizzlysoftware.util.RetrofitUtils;

public class DotykackaApiClient {
    public final OAuthServiceFacade oauthService;
    public final ProductServiceFacade productService;
    public final CustomerServiceFacade customerService;
    public final SalesServiceFacade salesService;
    public final SupplierServiceFacade supplierService;
    public final EmployeeServiceFacade employeeService;
    public final CategoryServiceFacade categoryService;
    public final BranchServiceFacade branchService;
    public final WarehouseServiceFacade warehouseService;
    public final TagServiceFacade tagService;
    public final TableSeatServiceFacade tableSeatService;
    protected Configuration configuration;
    protected AccessTokenProvider accessTokenProvider;
    protected ApiTokenProvider apiTokenProvider;

    public DotykackaApiClient(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration).clone();
        OkHttpClient oAuthHttpClient = OkHttpClientUtils.builder().addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        this.oauthService = new OAuthServiceFacade(RetrofitUtils.service(oAuthHttpClient, configuration.url + "/oauth", OAuthService.class));
        this.apiTokenProvider = configuration.apiTokenAuthCredentials == null ? new ApiTokenProvider(this.oauthService, new OAuthApiToken(configuration.apiToken)) : new ApiTokenProvider(this.oauthService, configuration.apiTokenAuthCredentials);
        this.accessTokenProvider = new AccessTokenProvider(this.oauthService, this.apiTokenProvider, configuration.accessTokenAuthCredentials, configuration.apiToken);
        OkHttpClient secureServiceHttpClient = OkHttpClientUtils.builder().addInterceptor((Interceptor)new OAuthRequestInterceptor(this.accessTokenProvider)).addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        this.branchService = new BranchServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/branches", BranchService.class));
        this.categoryService = new CategoryServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/category", CategoryService.class));
        this.customerService = new CustomerServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/customer", CustomerService.class));
        this.employeeService = new EmployeeServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/employee", EmployeeService.class));
        this.productService = new ProductServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/product", ProductService.class));
        this.salesService = new SalesServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/receipt", ReceiptService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/order", OrderService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/order-open", OrderOpenService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/moneylog", MoneylogService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/sales", SalesService.class));
        this.supplierService = new SupplierServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/supplier", SupplierService.class));
        this.tableSeatService = new TableSeatServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/tableseat", TableSeatService.class));
        this.tagService = new TagServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/tag", TagService.class));
        this.warehouseService = new WarehouseServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/warehouse", WarehouseService.class));
    }
}

