/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.util;

import java.util.Objects;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.oauth.OAuthAccessToken;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.oauth.OAuthApiToken;
import pl.grizzlysoftware.dotykacka.client.v1.facade.OAuthServiceFacade;
import pl.grizzlysoftware.dotykacka.model.Credentials;
import pl.grizzlysoftware.dotykacka.util.ApiTokenProvider;
import pl.grizzlysoftware.dotykacka.validator.OAuthAccessTokenValidator;
import pl.grizzlysoftware.util.TokenProvider;

public class AccessTokenProvider
implements TokenProvider<OAuthAccessToken> {
    protected final OAuthServiceFacade oauthService;
    protected OAuthAccessToken accessToken;
    protected OAuthAccessTokenValidator validator;
    protected Credentials credentials;
    protected ApiTokenProvider apiTokenProvider;

    public AccessTokenProvider(OAuthServiceFacade oauthService, ApiTokenProvider apiTokenProvider, Credentials credentials, String apiToken) {
        this.oauthService = Objects.requireNonNull(oauthService);
        this.apiTokenProvider = Objects.requireNonNull(apiTokenProvider);
        this.apiTokenProvider.setApiToken(apiToken);
        this.credentials = Objects.requireNonNull(credentials);
        this.validator = new OAuthAccessTokenValidator();
    }

    public AccessTokenProvider(OAuthServiceFacade oauthService, ApiTokenProvider apiTokenProvider, OAuthAccessTokenValidator validator, Credentials credentials, String apiToken) {
        this.oauthService = Objects.requireNonNull(oauthService);
        this.apiTokenProvider = Objects.requireNonNull(apiTokenProvider);
        this.apiTokenProvider.setApiToken(apiToken);
        this.credentials = Objects.requireNonNull(credentials);
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public OAuthAccessToken acquireToken() {
        OAuthApiToken apiToken = this.apiTokenProvider.acquireToken();
        if (this.accessToken == null || !this.validator.isValid(this.accessToken)) {
            this.accessToken = this.oauthService.accessToken(this.credentials.username, this.credentials.password, apiToken.token);
        }
        return this.accessToken;
    }
}

