/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1.facade;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Objects;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.Moneylog;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.Order;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.ReceiptItem;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.ReceiptItemDateFields;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.Shift;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.sales.report.SalesReport;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.MoneylogService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.OrderOpenService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.OrderService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.ReceiptService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.SalesService;
import pl.grizzlysoftware.dotykacka.client.v1.facade.BasicDotykackaApiServiceFacade;
import pl.grizzlysoftware.dotykacka.util.BatchLoader;

public class SalesServiceFacade
extends BasicDotykackaApiServiceFacade {
    private static final DateTimeFormatter RECEIPTS_RANGE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final String RECEIPTS_RANGE_PATTERN = "%s-%s";
    protected ReceiptService receiptService;
    protected OrderService orderService;
    protected OrderOpenService orderOpenService;
    protected MoneylogService moneylogService;
    protected SalesService salesService;
    protected BatchLoader batchLoader;

    public SalesServiceFacade(Integer cloudId, ReceiptService receiptService, OrderService orderService, OrderOpenService orderOpenService, MoneylogService moneylogService, SalesService salesService) {
        super(cloudId);
        this.receiptService = Objects.requireNonNull(receiptService);
        this.orderService = Objects.requireNonNull(orderService);
        this.orderOpenService = Objects.requireNonNull(orderOpenService);
        this.moneylogService = Objects.requireNonNull(moneylogService);
        this.salesService = Objects.requireNonNull(salesService);
        this.batchLoader = new BatchLoader(100);
    }

    public Moneylog getMoneylog(Integer branchId, Long moneylogId) {
        Moneylog out = this.execute(this.moneylogService.getMoneylogById(this.cloudId, branchId, moneylogId));
        return out;
    }

    public Collection<Moneylog> getMoneylogs(LocalDateTime startDate, LocalDateTime endDate, String dateField, Integer limit, Integer offset, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        Collection<Moneylog> out = this.execute(this.moneylogService.getMoneylogs(this.cloudId, dateRange, dateField, limit, offset, sort));
        return out;
    }

    public Collection<Moneylog> getMoneylogs(LocalDateTime startDate, LocalDateTime endDate, String dateField, String sort) {
        Collection out = this.batchLoader.load(page -> this.getMoneylogs(startDate, endDate, dateField, page.limit, page.offset, sort));
        return out;
    }

    public Collection<Moneylog> getMoneylogs(LocalDateTime startDate, LocalDateTime endDate, String dateField) {
        Collection<Moneylog> out = this.getMoneylogs(startDate, endDate, dateField, null);
        return out;
    }

    public Collection<Moneylog> getMoneylogs(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField, Integer limit, Integer offset, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        Collection<Moneylog> out = this.execute(this.moneylogService.getMoneylogs(this.cloudId, branchId, dateRange, dateField, limit, offset, sort));
        return out;
    }

    public Collection<Moneylog> getMoneylogs(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField, String sort) {
        Collection out = this.batchLoader.load(page -> this.getMoneylogs(branchId, startDate, endDate, dateField, page.limit, page.offset, sort));
        return out;
    }

    public Collection<Moneylog> getMoneylogs(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField) {
        Collection<Moneylog> out = this.getMoneylogs(branchId, startDate, endDate, dateField, null);
        return out;
    }

    public Collection<Shift> getShiftRanges(Integer branchId, Integer limit, Integer offset) {
        Collection<Shift> out = this.execute(this.moneylogService.getShiftRanges(this.cloudId, branchId, limit, offset));
        return out;
    }

    public Collection<Shift> getShiftRanges(Integer branchId) {
        Collection out = this.batchLoader.load(page -> this.getShiftRanges(branchId, page.limit, page.offset));
        return out;
    }

    public Order getOrder(Long orderId) {
        Order out = this.execute(this.orderService.getOrderById(this.cloudId, orderId));
        return out;
    }

    public Order getOrder(Integer branchId, Long orderId) {
        Order out = this.execute(this.orderService.getOrderById(this.cloudId, branchId, orderId));
        return out;
    }

    public Collection<Order> getOrders(LocalDateTime startDate, LocalDateTime endDate, String dateField, Integer limit, Integer offset, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        Collection<Order> out = this.execute(this.orderService.getOrders(this.cloudId, dateRange, dateField, limit, offset, sort));
        return out;
    }

    public Collection<Order> getOrders(LocalDateTime startDate, LocalDateTime endDate, String dateField, String sort) {
        Collection out = this.batchLoader.load(page -> this.getOrders(startDate, endDate, dateField, page.limit, page.offset, sort));
        return out;
    }

    public Collection<Order> getOrders(LocalDateTime startDate, LocalDateTime endDate, String dateField) {
        Collection<Order> out = this.getOrders(startDate, endDate, dateField, null);
        return out;
    }

    public Collection<Order> getOrders(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField, Integer limit, Integer offset, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        Collection<Order> out = this.execute(this.orderService.getOrders(this.cloudId, branchId, dateRange, dateField, limit, offset, sort));
        return out;
    }

    public Collection<Order> getOrders(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField, String sort) {
        Collection out = this.batchLoader.load(page -> this.getOrders(branchId, startDate, endDate, dateField, page.limit, page.offset, sort));
        return out;
    }

    public Collection<Order> getOrders(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField) {
        Collection<Order> out = this.getOrders(branchId, startDate, endDate, dateField, null);
        return out;
    }

    public Collection<Order> getOpenOrders(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField, Integer limit, Integer offset, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        Collection<Order> out = this.execute(this.orderOpenService.getOpenOrders(this.cloudId, branchId, dateRange, dateField, limit, offset, sort));
        return out;
    }

    public Collection<Order> getOpenOrders(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField, String sort) {
        Collection out = this.batchLoader.load(page -> this.getOpenOrders(branchId, startDate, endDate, dateField, page.limit, page.offset, sort));
        return out;
    }

    public Collection<Order> getOpenOrders(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, String dateField) {
        Collection<Order> out = this.getOpenOrders(branchId, startDate, endDate, dateField, null);
        return out;
    }

    public SalesReport getSalesReport(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, Boolean isVatPayer) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        SalesReport out = this.execute(this.salesService.getSalesReport(this.cloudId, branchId, dateRange, isVatPayer));
        return out;
    }

    public ReceiptItem getReceiptItem(Long receiptId) {
        ReceiptItem out = this.execute(this.receiptService.getReceiptItem(this.cloudId, receiptId));
        return out;
    }

    public Collection<ReceiptItem> getReceiptItems(LocalDateTime startDate, LocalDateTime endDate, Integer limit, Integer offset, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        Collection<ReceiptItem> out = this.execute(this.receiptService.getReceiptItems(this.cloudId, dateRange, ReceiptItemDateFields.COMPLETED.name, limit, offset, sort));
        return out;
    }

    public Collection<ReceiptItem> getReceiptItems(Integer branchId, LocalDateTime startDate, LocalDateTime endDate, Integer limit, Integer offset, String sort) {
        String dateRange = String.format(RECEIPTS_RANGE_PATTERN, RECEIPTS_RANGE_DATE_FORMATTER.format(startDate), RECEIPTS_RANGE_DATE_FORMATTER.format(endDate));
        Collection<ReceiptItem> out = this.execute(this.receiptService.getReceiptItems(this.cloudId, branchId, dateRange, ReceiptItemDateFields.COMPLETED.name, limit, offset, sort));
        return out;
    }

    public Collection<ReceiptItem> getReceiptItems(LocalDateTime startDate, LocalDateTime endDate, String sort) {
        Collection out = this.batchLoader.load(page -> this.getReceiptItems(startDate, endDate, page.limit, page.offset, sort));
        return out;
    }

    public Collection<ReceiptItem> getReceiptItems(LocalDateTime startDate, LocalDateTime endDate) {
        Collection<ReceiptItem> out = this.getReceiptItems(startDate, endDate, null);
        return out;
    }
}

