/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.util;

import java.io.IOException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.oauth.OAuthAccessToken;
import pl.grizzlysoftware.dotykacka.util.AccessTokenProvider;

public class OAuthRequestInterceptor
implements Interceptor {
    private AccessTokenProvider accessTokenProvider;

    public OAuthRequestInterceptor(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = Objects.requireNonNull(accessTokenProvider);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        OAuthAccessToken accessToken = this.accessTokenProvider.acquireToken();
        Request request = chain.request().newBuilder().header("Authorization", "Bearer " + accessToken.token).build();
        return chain.proceed(request);
    }
}

