/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1.facade;

import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.customer.Customer;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.CustomerService;
import pl.grizzlysoftware.dotykacka.client.v1.facade.DotykackaApiServiceFacade;
import pl.grizzlysoftware.dotykacka.util.BatchLoader;

public class CustomerServiceFacade
extends DotykackaApiServiceFacade<CustomerService> {
    protected BatchLoader batchLoader = new BatchLoader(100);

    public CustomerServiceFacade(Integer cloudId, CustomerService service) {
        super(cloudId, service);
    }

    public Customer getCustomer(Long id) {
        Customer out = this.execute(((CustomerService)this.service).getCustomer(this.cloudId, id));
        return out;
    }

    public Collection<Customer> getAllCustomers(int limit, int offset, String sortBy) {
        Collection<Customer> out = this.execute(((CustomerService)this.service).getCustomers(this.cloudId, limit, offset, sortBy));
        return out;
    }

    public Collection<Customer> getAllCustomers(String sortBy) {
        Collection out = this.batchLoader.load(page -> this.getAllCustomers(page.limit, page.offset, sortBy));
        return out;
    }

    public Collection<Customer> getAllCustomers() {
        Collection<Customer> out = this.getAllCustomers(null);
        return out;
    }

    public Collection<Customer> getCustomers(int limit, int offset) {
        Collection<Customer> out = this.execute(((CustomerService)this.service).getCustomers(this.cloudId, limit, offset));
        return out;
    }

    public Customer updateCustomer(Long id, Customer customer) {
        return this.execute(((CustomerService)this.service).updateCustomer(this.cloudId, id, customer));
    }

    public Customer createCustomer(Customer customer) {
        return this.execute(((CustomerService)this.service).createCustomer(this.cloudId, customer));
    }

    public Customer deleteCustomer(Long id, boolean anonymize) {
        return this.execute(((CustomerService)this.service).deleteCustomer(this.cloudId, id, anonymize));
    }

    public Customer deleteCustomer(Long id) {
        return this.execute(((CustomerService)this.service).deleteCustomer(this.cloudId, id, null));
    }
}

