/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.IChangeableByClient;

public abstract class Chart
extends FormElement
implements Boundable,
IChangeableByClient {
    protected static final String ATTR_X_AXIS_LABEL = "xAxisLabel";
    protected static final String ATTR_Y_AXIS_LABEL = "yAxisLabel";
    protected static final String ATTR_Y_AXIS_MIN = "yAxisMin";
    protected static final String ATTR_Y_AXIS_MAX = "yAxisMax";
    protected static final String ATTR_TITLE = "title";
    protected static final String X = "X";
    protected static final String Y = "Y";
    public static final String EMPTY_STRING = "";
    private Number yAxisMin;
    private Number yAxisMax;
    private String xAxisLabel = "";
    private String yAxisLabel = "";
    private String title = "";
    @JsonIgnore
    @XMLProperty(value="xAxisLabel")
    @DocumentedComponentAttribute(boundable=true, value="Label of X axis")
    private ModelBinding<String> axisXLabelModelBinding;
    @JsonIgnore
    @XMLProperty(value="yAxisLabel")
    @DocumentedComponentAttribute(boundable=true, value="Label of Y axis")
    private ModelBinding<String> axisYLabelModelBinding;
    @JsonIgnore
    @XMLProperty(value="yAxisMin")
    @DesignerXMLProperty(allowedTypes={Number.class})
    @DocumentedComponentAttribute(boundable=true, value="Min value on Y axis")
    private ModelBinding<Number> axisYMinModelBinding;
    @JsonIgnore
    @XMLProperty(value="yAxisMax")
    @DesignerXMLProperty(allowedTypes={Number.class})
    @DocumentedComponentAttribute(boundable=true, value="Max value of Y axis")
    private ModelBinding<Number> axisYMaxModelBinding;
    @JsonIgnore
    @XMLProperty(value="title")
    @DocumentedComponentAttribute(boundable=true, value="Title of a chart")
    private ModelBinding<String> titleModelBinding;

    public Chart(Form form) {
        super(form);
    }

    protected Number getValue(ModelBinding modelBinding) {
        if (modelBinding == null) {
            return null;
        }
        BindingResult bindingResult = modelBinding.getBindingResult();
        if (bindingResult != null) {
            Object value = bindingResult.getValue();
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
        }
        return 0;
    }

    protected String getStringValue(ModelBinding modelBinding) {
        if (modelBinding == null) {
            return null;
        }
        BindingResult bindingResult = modelBinding.getBindingResult();
        if (bindingResult == null) {
            return null;
        }
        return (String)bindingResult.getValue();
    }

    public void updateModel(ValueChange valueChange) {
        super.updateView();
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.updateValues(elementChanges);
        return elementChanges;
    }

    protected void updateValues(ElementChanges elementChanges) {
        this.yAxisMin = this.processNumberValueBinding(elementChanges, ATTR_Y_AXIS_MIN, this.getYAxisMin(), this.getAxisYMinModelBinding());
        this.yAxisMax = this.processNumberValueBinding(elementChanges, ATTR_Y_AXIS_MAX, this.getYAxisMax(), this.getAxisYMaxModelBinding());
        this.yAxisLabel = this.processStringValueBinding(elementChanges, ATTR_Y_AXIS_LABEL, this.getYAxisLabel(), this.getAxisYLabelModelBinding());
        this.xAxisLabel = this.processStringValueBinding(elementChanges, ATTR_X_AXIS_LABEL, this.getXAxisLabel(), this.getAxisXLabelModelBinding());
        this.title = this.processStringValueBinding(elementChanges, ATTR_TITLE, this.getTitle(), this.getTitleModelBinding());
    }

    protected Number processNumberValueBinding(ElementChanges elementChanges, String attributeName, Number oldValue, ModelBinding<Number> modelBinding) {
        BindingResult bindingResult;
        if (modelBinding != null && (bindingResult = modelBinding.getBindingResult()) != null) {
            Number newValue = (Number)bindingResult.getValue();
            if (!this.areValuesTheSame(newValue, oldValue)) {
                elementChanges.addChange(attributeName, (Object)newValue);
            }
            return newValue;
        }
        return oldValue;
    }

    protected String processStringValueBinding(ElementChanges elementChanges, String attributeName, String oldValue, ModelBinding modelBinding) {
        BindingResult bindingResult;
        if (modelBinding != null && (bindingResult = modelBinding.getBindingResult()) != null) {
            String newValue = this.convertBindingValueToString(bindingResult);
            if (!this.areValuesTheSame(newValue, oldValue)) {
                elementChanges.addChange(attributeName, (Object)newValue);
            }
            return newValue;
        }
        return oldValue;
    }

    public Number getYAxisMin() {
        return this.yAxisMin;
    }

    public Number getYAxisMax() {
        return this.yAxisMax;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public String getTitle() {
        return this.title;
    }

    public ModelBinding<String> getAxisXLabelModelBinding() {
        return this.axisXLabelModelBinding;
    }

    public void setAxisXLabelModelBinding(ModelBinding<String> axisXLabelModelBinding) {
        this.axisXLabelModelBinding = axisXLabelModelBinding;
    }

    public ModelBinding<String> getAxisYLabelModelBinding() {
        return this.axisYLabelModelBinding;
    }

    public void setAxisYLabelModelBinding(ModelBinding<String> axisYLabelModelBinding) {
        this.axisYLabelModelBinding = axisYLabelModelBinding;
    }

    public ModelBinding<Number> getAxisYMinModelBinding() {
        return this.axisYMinModelBinding;
    }

    public void setAxisYMinModelBinding(ModelBinding<Number> axisYMinModelBinding) {
        this.axisYMinModelBinding = axisYMinModelBinding;
    }

    public ModelBinding<Number> getAxisYMaxModelBinding() {
        return this.axisYMaxModelBinding;
    }

    public void setAxisYMaxModelBinding(ModelBinding<Number> axisYMaxModelBinding) {
        this.axisYMaxModelBinding = axisYMaxModelBinding;
    }

    public ModelBinding<String> getTitleModelBinding() {
        return this.titleModelBinding;
    }

    public void setTitleModelBinding(ModelBinding<String> titleModelBinding) {
        this.titleModelBinding = titleModelBinding;
    }
}

