/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.fhframework.BindingResult;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.model.forms.SelectComboMenu;
import pl.fhframework.validation.ConstraintViolation;
import pl.fhframework.validation.Validator;

@Component
public class SelectComboIsRequired
implements Validator<SelectComboMenu> {
    @Autowired
    private MessageService messageService;

    public List<ConstraintViolation<SelectComboMenu>> validate(SelectComboMenu combo) {
        ArrayList<ConstraintViolation<SelectComboMenu>> violations = new ArrayList<ConstraintViolation<SelectComboMenu>>();
        if (!combo.isRequired()) {
            return violations;
        }
        BindingResult selectedBindingResult = combo.getModelBinding().getBindingResult();
        if (this.isValueEmptyInBinding(selectedBindingResult)) {
            this.addConstraintViolation(violations, combo, this.messageService.getAllBundles().getMessage("fh.core.validation.field.is_required"));
        }
        return violations;
    }

    private boolean isValueEmptyInBinding(BindingResult bindingResult) {
        return bindingResult.getValue() == null || "".equals(bindingResult.getValue().toString());
    }
}

