/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.csv;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import pl.fhframework.SessionManager;
import pl.fhframework.core.FhException;
import pl.fhframework.event.EventRegistry;
import pl.fhframework.io.FileService;
import pl.fhframework.io.TemporaryResource;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.OutputLabel;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableCell;
import pl.fhframework.model.forms.TablePaged;
import pl.fhframework.model.forms.TableRow;

@Service
public class CsvService {
    private final FileService fileService;
    private final EventRegistry eventRegistry;

    public void exportTableToCsv(Table table) {
        TemporaryResource resource = this.createTempResource();
        try (FileWriter output = new FileWriter(resource.getFile());
             CSVPrinter printer = new CSVPrinter((Appendable)output, CSVFormat.EXCEL.withDelimiter(';'));){
            List headers = table.getColumns().stream().map(Column::getLabel).collect(Collectors.toList());
            printer.printRecord(headers);
            if (table instanceof TablePaged) {
                this.exportTablePagedRows(printer, (TablePaged)table);
            } else {
                table.getTableRows().forEach(row -> this.exportRow(printer, (TableRow)row));
            }
            this.eventRegistry.fireDownloadEvent((Resource)resource);
        }
        catch (IOException e) {
            throw new FhException("Error during Table to CSV export.", (Throwable)e);
        }
    }

    private TemporaryResource createTempResource() {
        try {
            return (TemporaryResource)this.fileService.createNewTemporaryResource(UUID.randomUUID().toString() + ".csv", SessionManager.getUserSession()).getSecond();
        }
        catch (IOException e) {
            throw new FhException("Cannot create empty CSV file.", (Throwable)e);
        }
    }

    private void exportTablePagedRows(CSVPrinter printer, TablePaged tablePaged) {
        PageRequest request;
        int oldPage = tablePaged.getPageNumber();
        int page = 0;
        do {
            request = PageRequest.of((int)page, (int)tablePaged.getPageSize());
            tablePaged.getPageModel().doRefresh((Pageable)request);
            tablePaged.processComponents();
            tablePaged.updateView();
            tablePaged.getTableRows().forEach(row -> this.exportRow(printer, (TableRow)row));
            ++page;
        } while (tablePaged.getPageModel().getPage().hasNext());
        request = PageRequest.of((int)oldPage, (int)tablePaged.getPageSize());
        tablePaged.getPageModel().doRefresh((Pageable)request);
    }

    private void exportRow(CSVPrinter printer, TableRow tableRow) {
        ArrayList<String> values = new ArrayList<String>();
        for (FormElement element : tableRow.getTableCells()) {
            if (!TableCell.class.isAssignableFrom(element.getClass())) continue;
            StringBuilder builder = new StringBuilder();
            for (FormElement formElement : ((TableCell)element).getSubcomponents()) {
                if (!(formElement instanceof OutputLabel)) continue;
                OutputLabel outputLabel = (OutputLabel)formElement;
                outputLabel.updateView();
                if (outputLabel.getValue() == null) continue;
                if (builder.length() == 0) {
                    builder.append(outputLabel.getValue());
                    continue;
                }
                builder.append(" ").append(outputLabel.getValue());
            }
            values.add(builder.toString());
        }
        try {
            printer.printRecord(values);
        }
        catch (IOException e) {
            throw new FhException("Error during Table Row to CSV export.", (Throwable)e);
        }
    }

    public CsvService(FileService fileService, EventRegistry eventRegistry) {
        this.fileService = fileService;
        this.eventRegistry = eventRegistry;
    }
}

