/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Component responsible for displaying calendar,only date could be set in this field", icon="fa fa-calendar")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Group.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
public class Calendar
extends BaseInputField {
    private static final String VALUES_ATTR = "values";
    private static final String MIN_DATE_ATTR = "minDate";
    private static final String MAX_DATE_ATTR = "maxDate";
    private static final String CHANGE_MONTH_ATTR = "changeMonth";
    private static final String CHANGE_YEAR_ATTR = "changeYear";
    private static final String BLOCKED_DATES_ATTR = "blockedDates";
    private static final String DELIMITER = "\\|";
    @XMLProperty
    private String currentDate;
    private String minDate;
    @JsonIgnore
    @XMLProperty(value="minDate")
    @DocumentedComponentAttribute(boundable=true, value="Minimum date for allowed selection.")
    private ModelBinding minDateBinding;
    private String maxDate;
    @JsonIgnore
    @XMLProperty(value="maxDate")
    @DocumentedComponentAttribute(boundable=true, value="Maximum date for allowed selection.")
    private ModelBinding maxDateBinding;
    private List<String> blockedDates;
    @JsonIgnore
    @XMLProperty(value="blockedDates")
    @DocumentedComponentAttribute(boundable=true, value="Collection of dates blocked for selection.")
    private ModelBinding blockedDatesBinding;
    private MultiValueMap<Map.Entry<String, String>, String> values = new LinkedMultiValueMap();
    @JsonIgnore
    @XMLProperty(value="values")
    @DocumentedComponentAttribute(boundable=true, value="Collection of selected values of different types to be displayed.")
    private ModelBinding valuesBinding;
    private boolean changeMonth = false;
    @JsonIgnore
    @XMLProperty(value="changeMonth")
    @DesignerXMLProperty(priority=5, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC)
    @DocumentedComponentAttribute(boundable=true, defaultValue="false", value="User can define if calendar displays menu for month selection.")
    private ModelBinding<Boolean> changeMonthBinding;
    private boolean changeYear = false;
    @JsonIgnore
    @XMLProperty(value="changeYear")
    @DesignerXMLProperty(priority=4, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC)
    @DocumentedComponentAttribute(boundable=true, defaultValue="false", value="User can define if calendar displays menu for year selection.")
    private ModelBinding<Boolean> changeYearBinding;

    public Calendar(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        this.currentDate = this.convertValueToString(LocalDate.now());
    }

    @Override
    public ElementChanges updateView() {
        boolean blockedDatesValueChanged;
        boolean maxDateValueChanged;
        boolean minDateValueChanged;
        boolean valuesChanged;
        ElementChanges elementChanges = super.updateView();
        elementChanges.setFormId(this.getForm().getId());
        elementChanges.setFormElementId(this.getId());
        if (this.changeMonthBinding != null) {
            this.changeMonth = this.changeMonthBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.changeMonth, CHANGE_MONTH_ATTR);
        }
        if (this.changeYearBinding != null) {
            this.changeYear = this.changeYearBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.changeYear, CHANGE_YEAR_ATTR);
        }
        if (valuesChanged = this.processValuesBinding()) {
            elementChanges.addChange(VALUES_ATTR, this.values);
        }
        if (minDateValueChanged = this.processMinDateBinding()) {
            elementChanges.addChange(MIN_DATE_ATTR, (Object)this.minDate);
        }
        if (maxDateValueChanged = this.processMaxDateBinding()) {
            elementChanges.addChange(MAX_DATE_ATTR, (Object)this.maxDate);
        }
        if (blockedDatesValueChanged = this.processBlockedDatesBinding()) {
            elementChanges.addChange(BLOCKED_DATES_ATTR, this.blockedDates);
        }
        if (valuesChanged || minDateValueChanged || maxDateValueChanged || blockedDatesValueChanged) {
            this.refreshView();
        }
        return elementChanges;
    }

    private boolean processMinDateBinding() {
        BindingResult minDateBindingResult;
        boolean minDateValueChanged = false;
        if (this.minDateBinding != null && (minDateBindingResult = this.minDateBinding.getBindingResult()) != null) {
            Object newValue = minDateBindingResult.getValue();
            if (newValue instanceof String) {
                this.minDate = (String)newValue;
                minDateValueChanged = true;
            } else if (newValue instanceof LocalDate) {
                this.minDate = this.convertValueToString(newValue);
                minDateValueChanged = true;
            }
        }
        return minDateValueChanged;
    }

    private boolean processMaxDateBinding() {
        BindingResult maxDateBindingResult;
        boolean maxDateValueChanged = false;
        if (this.maxDateBinding != null && (maxDateBindingResult = this.maxDateBinding.getBindingResult()) != null) {
            Object newValue = maxDateBindingResult.getValue();
            if (newValue instanceof String) {
                this.maxDate = (String)newValue;
                maxDateValueChanged = true;
            } else if (newValue instanceof LocalDate) {
                this.maxDate = this.convertValueToString(newValue);
                maxDateValueChanged = true;
            }
        }
        return maxDateValueChanged;
    }

    private boolean processBlockedDatesBinding() {
        BindingResult blockedDatesValueBindingResult;
        boolean blockedDatesValueChanged = false;
        if (this.blockedDatesBinding != null && (blockedDatesValueBindingResult = this.blockedDatesBinding.getBindingResult()) != null) {
            List newValues;
            Object newValue = blockedDatesValueBindingResult.getValue();
            if (newValue instanceof String) {
                List newValues2;
                String valuesAsString = (String)newValue;
                String[] allValues = valuesAsString.split(DELIMITER);
                if (allValues.length > 0 && !Objects.equals(newValues2 = Arrays.stream(allValues).collect(Collectors.toList()), this.blockedDates)) {
                    this.blockedDates = newValues2;
                    blockedDatesValueChanged = true;
                }
            } else if (newValue instanceof Collection && !Objects.equals(newValues = ((Collection)newValue).stream().map(p -> this.convertValueToString(p)).collect(Collectors.toList()), this.blockedDates)) {
                this.blockedDates = newValues;
                blockedDatesValueChanged = true;
            }
        }
        return blockedDatesValueChanged;
    }

    private boolean processValuesBinding() {
        BindingResult valuesBindingResult;
        boolean valuesChanged = false;
        if (this.valuesBinding != null && (valuesBindingResult = this.valuesBinding.getBindingResult()) != null) {
            Object newValue = valuesBindingResult.getValue();
            MultiValueMap<Map.Entry<String, String>, String> newValues = new MultiValueMap<Map.Entry<String, String>, String>();
            if (newValue instanceof String) {
                String valuesAsString = (String)newValue;
                String[] allValues = valuesAsString.split(DELIMITER);
                if (allValues.length > 0) {
                    newValues.put(new AbstractMap.SimpleImmutableEntry<String, String>("", ""), Arrays.stream(allValues).collect(Collectors.toList()));
                    if (!Objects.equals(newValues, this.values)) {
                        this.values = newValues;
                        return true;
                    }
                }
            } else if (newValue instanceof Collection) {
                newValues.put(new AbstractMap.SimpleImmutableEntry<String, String>("", ""), ((Collection)newValue).stream().map(p -> this.convertValueToString(p)).collect(Collectors.toList()));
                if (!Objects.equals(newValues, this.values)) {
                    this.values = newValues;
                    return true;
                }
            } else if (newValue instanceof MultiValueMap && !Objects.equals(newValues = this.convertValues((MultiValueMap<Map.Entry<String, String>, LocalDate>)((MultiValueMap)newValue)), this.values)) {
                this.values = newValues;
                return true;
            }
        }
        return valuesChanged;
    }

    private void setBinding(ModelBinding valuesBinding, ModelBinding minDateBinding, ModelBinding maxDateBinding, ModelBinding blockedDatesBinding) {
        this.valuesBinding = valuesBinding;
        this.minDateBinding = minDateBinding;
        this.maxDateBinding = maxDateBinding;
        this.blockedDatesBinding = blockedDatesBinding;
    }

    private MultiValueMap<Map.Entry<String, String>, String> convertValues(MultiValueMap<Map.Entry<String, String>, LocalDate> value) {
        LinkedMultiValueMap convertedValues = new LinkedMultiValueMap();
        convertedValues.putAll(value.entrySet().stream().collect(Collectors.toMap(p -> (Map.Entry)p.getKey(), p -> ((List)p.getValue()).stream().map(s -> this.convertValueToString(s)).collect(Collectors.toList()))));
        return convertedValues;
    }

    @Override
    public Calendar createNewSameComponent() {
        return new Calendar(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        Calendar clone = (Calendar)baseClone;
        clone.setCurrentDate(this.getCurrentDate());
        clone.setMinDateBinding(table.getRowBinding(this.getMinDateBinding(), (Component)clone, iteratorReplacements));
        clone.setMaxDateBinding(table.getRowBinding(this.getMaxDateBinding(), (Component)clone, iteratorReplacements));
        clone.setBlockedDatesBinding(table.getRowBinding(this.getBlockedDatesBinding(), (Component)clone, iteratorReplacements));
        clone.setValuesBinding(table.getRowBinding(this.getValuesBinding(), (Component)clone, iteratorReplacements));
    }

    public String getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    public String getMinDate() {
        return this.minDate;
    }

    public ModelBinding getMinDateBinding() {
        return this.minDateBinding;
    }

    public void setMinDateBinding(ModelBinding minDateBinding) {
        this.minDateBinding = minDateBinding;
    }

    public String getMaxDate() {
        return this.maxDate;
    }

    public ModelBinding getMaxDateBinding() {
        return this.maxDateBinding;
    }

    public void setMaxDateBinding(ModelBinding maxDateBinding) {
        this.maxDateBinding = maxDateBinding;
    }

    public List<String> getBlockedDates() {
        return this.blockedDates;
    }

    public ModelBinding getBlockedDatesBinding() {
        return this.blockedDatesBinding;
    }

    public void setBlockedDatesBinding(ModelBinding blockedDatesBinding) {
        this.blockedDatesBinding = blockedDatesBinding;
    }

    public MultiValueMap<Map.Entry<String, String>, String> getValues() {
        return this.values;
    }

    public ModelBinding getValuesBinding() {
        return this.valuesBinding;
    }

    public void setValuesBinding(ModelBinding valuesBinding) {
        this.valuesBinding = valuesBinding;
    }

    public boolean isChangeMonth() {
        return this.changeMonth;
    }

    public ModelBinding<Boolean> getChangeMonthBinding() {
        return this.changeMonthBinding;
    }

    public void setChangeMonthBinding(ModelBinding<Boolean> changeMonthBinding) {
        this.changeMonthBinding = changeMonthBinding;
    }

    public boolean isChangeYear() {
        return this.changeYear;
    }

    public ModelBinding<Boolean> getChangeYearBinding() {
        return this.changeYearBinding;
    }

    public void setChangeYearBinding(ModelBinding<Boolean> changeYearBinding) {
        this.changeYearBinding = changeYearBinding;
    }
}

