/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.logging.handlers;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import pl.fhframework.FormsHandler;
import pl.fhframework.SessionManager;
import pl.fhframework.UserSession;
import pl.fhframework.WebSocketContext;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.core.logging.ErrorInformation;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.logging.handler.NonResponsiveInformationHandler;
import pl.fhframework.core.uc.handlers.RunUseCaseHandler;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.dto.AbstractMessage;
import pl.fhframework.model.dto.IErrorCarrierMessage;
import pl.fhframework.model.dto.OutMessageEventHandlingResult;

@Service
public class MessageErrorInformationHandler
extends RunUseCaseHandler
implements NonResponsiveInformationHandler {
    private static final String NEW_LINE = System.getProperty("line.separator");
    @Value(value="${usecase.action.error.redirect:}")
    private String actionRedirectUseCase;
    @Value(value="${system.error.redirect:}")
    private String redirectUseCase;
    @Autowired
    private MessageService messageService;

    public boolean handle(UserSession session, IErrorCarrierMessage message, List<ErrorInformation> errors, FormsHandler formsHandler, String requestId) {
        message.setErrors(errors);
        return true;
    }

    public boolean handleFailure(boolean isSendingMessageForbidden, FormsHandler formsHandler, String requestId, List<ErrorInformation> errors) {
        if (isSendingMessageForbidden) {
            return false;
        }
        UserSession userSession = SessionManager.getUserSession();
        if (userSession.getUseCaseContainer().getCurrentUseCaseContext() != null) {
            try {
                this.showMessageAndRunUseCase(userSession.getUseCaseContainer(), this.messageTitle(), this.buildMessage(errors), StringUtils.nvl((String[])new String[]{this.redirectUseCase, this.actionRedirectUseCase}));
                errors.clear();
                formsHandler.finishEventHandling(requestId, WebSocketContext.fromThreadLocals());
                return true;
            }
            catch (Exception finishingException) {
                FhLogger.errorSuppressed((Throwable)finishingException);
                return false;
            }
        }
        try {
            OutMessageEventHandlingResult response = new OutMessageEventHandlingResult();
            response.setErrors(errors);
            formsHandler.sendResponse(requestId, (AbstractMessage)response);
            return true;
        }
        catch (Exception sendingException) {
            FhLogger.errorSuppressed((Throwable)sendingException);
            return false;
        }
    }

    public String buildMessage(List<ErrorInformation> errors) {
        StringBuilder message = new StringBuilder(this.buildGeneralMessage(errors));
        message.append(NEW_LINE);
        message.append(NEW_LINE);
        for (ErrorInformation error : errors) {
            message.append(NonResponsiveInformationHandler.buildSingleErrorMessage((ErrorInformation)error));
            message.append(NEW_LINE);
        }
        message.append(NEW_LINE);
        message.append(this.buildFooterMessage());
        return message.toString();
    }

    protected String buildGeneralMessage(List<ErrorInformation> errors) {
        return this.messageService.getAllBundles().getMessage("fh.core.action.error");
    }

    protected String buildFooterMessage() {
        UserSession userSession = SessionManager.getUserSession();
        String login = userSession.getSystemUser().getLogin();
        String sessionUniqueId = userSession.getConversationUniqueId();
        String defaultMsg = String.format("Current user is %s with session ID %s.", login, sessionUniqueId);
        Object[] params = new Object[]{login, sessionUniqueId};
        return this.getAllMessgages().getMessage("fh.core.toast.current_user_with_session", params, defaultMsg);
    }

    private MessageService.MessageBundle getAllMessgages() {
        return this.messageService.getAllBundles();
    }
}

