/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.expression.Expression;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.forms.IValidatedComponent;
import pl.fhframework.core.util.JsonUtil;
import pl.fhframework.core.util.SpelUtils;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.PresentationStyleEnum;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.AccessibilityEnum;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.BaseInputFieldWithKeySupport;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.IComboItem;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.InputFieldDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.validation.ValidationFactory;
import pl.fhframework.validation.FieldValidationResult;
import pl.fhframework.validation.FormFieldHints;
import pl.fhframework.validation.IValidationResults;
import pl.fhframework.validation.ValidationManager;

@TemplateControl(tagName="fh-combo")
@DesignerControl(defaultWidth=3)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Enables users to quickly find and select from a pre-populated list of values as they type, leveraging searching and filtering.", icon="fa fa-outdent")
@Control(parents={PanelGroup.class, Group.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
public class Combo
extends BaseInputFieldWithKeySupport {
    public static final String SELECTED_ITEM_ATTR = "selectedItem";
    protected static final String MULTISELECT_RAW_VALUE_ATTR = "multiselectRawValue";
    private static final String ON_SPECIAL_KEY_ATTR = "onSpecialKey";
    private static final String ON_DBL_SPECIAL_KEY_ATTR = "onDblSpecialKey";
    private static final String ON_INPUT_ATTR = "onInput";
    private static final String ON_EMPTY_VALUE_ATTR = "onEmptyValue";
    private static final String VALUES_ATTR = "values";
    protected static final String TEXT = "text";
    protected static final String ADDED_TAG = "addedTag";
    private static final String FILTERED_VALUES = "filteredValues";
    private static final String FILTER_FUNCTION_ATTR = "filterFunction";
    private static final String FILTER_TEXT = "filterText";
    protected static final String SELECTED_INDEX_ATTR = "selectedIndex";
    protected static final String REMOVED_INDEX_ATTR = "removedIndex";
    protected static final String SELECTED_INDEX_GROUP_ATTR = "selectedIndexGroup";
    protected static final String CLEARED = "cleared";
    private static final String FORMATTER_ATTR = "formatter";
    protected static final String CURSOR = "cursor";
    private static final String FREE_TYPING = "freeTyping";
    private static final String EMPTY_VALUE_ATTR = "emptyValue";
    private static final String DISPLAY_FUNCTION_ATTR = "displayFunction";
    private static final String DISPLAY_RULE_ATTR = "displayExpression";
    private static final String ATTR_OPEN_ON_FOCUS = "openOnFocus";
    @XMLProperty(value="openOnFocus", defaultValue="true")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR, priority=86)
    @DocumentedComponentAttribute(defaultValue="true", value="Should prompt window be opened when field gains focus.")
    private Boolean openOnFocus;
    @XMLProperty(defaultValue="0")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="Delay onInput action for specific miliseconds. Value must be between 0 and 10000.", defaultValue="0")
    private Integer onInputTimeout;
    @XMLProperty(defaultValue="-")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on every action in input,  that method will be executed. Action is fired, while component is active.", defaultValue="-")
    private ActionBinding onInput;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on clearing value,  that method will be executed. Action is fired, while component is active.")
    private ActionBinding onEmptyValue;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, that will be called every time a special key (Ctrl+Space) is pressed.")
    private ActionBinding onSpecialKey;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, that will be called every time a special key (Ctrl+Space) is pressed 2 times.")
    private ActionBinding onDblSpecialKey;
    @JsonIgnore
    protected Object selectedItem;
    @JsonIgnore
    protected int selectedItemIndex;
    protected String rawValue;
    @JsonIgnore
    protected String filterText = "";
    @JsonIgnore
    @XMLProperty(value="filterText")
    @DesignerXMLProperty(previewValueProvider=InputFieldDesignerPreviewProvider.class, priority=120, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC)
    @DocumentedComponentAttribute(boundable=true, value="Binding represents value of filter text")
    private ModelBinding filterTextBinding;
    @JsonIgnore
    protected MultiValueMap<String, Object> values = new LinkedMultiValueMap();
    @JsonIgnore
    protected MultiValueMap<String, Object> filteredObjectValues = new LinkedMultiValueMap();
    protected MultiValueMap<String, ComboItemDTO> filteredValues = new LinkedMultiValueMap();
    @JsonIgnore
    @XMLProperty(value="values")
    @DesignerXMLProperty(commonUse=true, allowedTypes={Collection.class, MultiValueMap.class, String.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=81)
    private ModelBinding valuesBinding;
    protected boolean cleared = false;
    @JsonIgnore
    protected BiPredicate<Object, String> filterFunction;
    @JsonIgnore
    @XMLProperty(value="filterFunction")
    @DesignerXMLProperty(allowedTypes={BiPredicate.class})
    @DocumentedComponentAttribute(defaultValue="Default function: (model, value) -> ((String) model).toLowerCase().contains(value.toLowerCase())", boundable=true, value="Name of model object (java.util.function.BiPredicate) which will be used to filter items by text.")
    private ModelBinding filterFunctionBinding;
    @JsonIgnore
    protected boolean filterInvoked;
    private boolean emptyValue;
    @JsonIgnore
    @XMLProperty(value="emptyValue")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(defaultValue="false", value="Defines if value passed can be empty", boundable=true)
    private ModelBinding<Boolean> emptyValueBinding;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Defines if combo values should be present even if no text is typed")
    protected boolean preload;
    @JsonIgnore
    @XMLProperty(value="formatter")
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistent with value of pl.fhframework.formatter.FhFormatter annotation.")
    private String formatter;
    @JsonIgnore
    protected boolean firstLoad = true;
    protected boolean freeTyping = false;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Determines if multiselect is enabled in combo. If multiselect is set to true, value has to be set to Collection.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=10)
    protected boolean multiselect;
    @XMLProperty
    @DocumentedComponentAttribute(value="Set autocompleter width based on field's width.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=10)
    protected Integer widthRatio;
    protected String multiselectRawValue;
    @JsonIgnore
    @XMLProperty(value="freeTyping")
    @DocumentedComponentAttribute(boundable=true, defaultValue="false", value="Defines if new values could be typed be user.  Binding changes may not be respected after initially showing this control.")
    private ModelBinding<Boolean> freeTypingBinding;
    protected Class<?> modelType = String.class;
    @JsonIgnore
    @XMLProperty(value="cursor")
    @DesignerXMLProperty(allowedTypes={Integer.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Binding represents cursor from model of Form, used inside of '{}', like {model}.")
    protected ModelBinding cursorBinding;
    @JsonIgnore
    @XMLProperty(value="displayFunction")
    @DesignerXMLProperty(allowedTypes={Function.class})
    @DocumentedComponentAttribute(boundable=true, value="Name of model object (java.util.function.Function) which will be used to format items as text.")
    private ModelBinding displayFunctionBinding;
    @JsonIgnore
    @XMLProperty(value="displayExpression")
    @DesignerXMLProperty(commonUse=true, allowedTypes={String.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Rule which will be used to format items as text.")
    private String displayExpression;
    @JsonIgnore
    private Function<Object, String> displayExpressionFunction;
    protected Integer cursor = 0;

    public Combo(Form form) {
        super(form);
    }

    @Override
    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_INPUT_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onInput);
        }
        if (ON_SPECIAL_KEY_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onSpecialKey);
        }
        if (ON_DBL_SPECIAL_KEY_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onDblSpecialKey);
        }
        if (ON_EMPTY_VALUE_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onEmptyValue);
        }
        return super.getEventHandler(eventData);
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        Integer cursor;
        String textObj = valueChange.getStringAttribute(TEXT);
        Boolean addedTag = valueChange.getBooleanAttribute(ADDED_TAG);
        if (textObj != null && textObj.equals("") && !this.multiselect) {
            this.cleared = true;
            this.filterText = "";
            this.processFiltering(this.filterText);
            this.selectedItemIndex = -1;
            this.selectedItem = null;
            this.rawValue = null;
            this.changeSelectedItemBinding();
        } else if (textObj != null) {
            String text;
            this.filterText = text = textObj;
            this.processFiltering(text);
            this.firstLoad = false;
            if (!this.isMultiselect()) {
                this.selectItemByFilterText();
                this.changeSelectedItemBinding();
            }
            if (this.freeTyping) {
                this.selectedItem = StringUtils.emptyToNull((String)text);
                if (this.isMultiselect() && Boolean.TRUE.equals(addedTag) && !StringUtils.isNullOrEmpty((String)this.rawValue)) {
                    this.selectedItem = this.rawValue;
                    this.changeSelectedItemBinding();
                } else {
                    this.rawValue = (String)this.selectedItem;
                }
                if (!this.isMultiselect()) {
                    this.changeSelectedItemBinding();
                }
            }
            this.updateFilterTextBinding();
        }
        Boolean cleared = valueChange.getBooleanAttribute(CLEARED);
        if (cleared != null && cleared.booleanValue() && textObj == null) {
            this.cleared = cleared;
            this.filterText = "";
            this.processFiltering(this.filterText);
            this.selectedItemIndex = -1;
            this.selectedItem = null;
            this.rawValue = null;
            this.multiselectRawValue = null;
            this.changeSelectedItemBinding();
            this.updateFilterTextBinding();
        } else if (valueChange.hasAttributeChanged(SELECTED_INDEX_ATTR)) {
            this.cleared = false;
            String key = valueChange.getStringAttribute(SELECTED_INDEX_GROUP_ATTR);
            this.selectedItemIndex = valueChange.getIntAttribute(SELECTED_INDEX_ATTR);
            this.selectedItem = this.selectedItemIndex >= 0 ? ((List)this.filteredObjectValues.get((Object)key)).get(this.selectedItemIndex) : null;
            this.changeSelectedItemBinding();
            this.rawValue = !this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
            this.multiselectRawValue = this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
            this.filterText = this.rawValue != null ? this.rawValue : "";
            this.processFiltering(this.filterText);
            this.updateFilterTextBinding();
        }
        if (valueChange.hasAttributeChanged(REMOVED_INDEX_ATTR)) {
            int removedIndexAttr = valueChange.getIntAttribute(REMOVED_INDEX_ATTR);
            List multiSelected = (List)this.getModelBinding().getBindingResult().getValue();
            multiSelected.remove(removedIndexAttr);
            this.selectedItem = new ArrayList(multiSelected);
            this.rawValue = !this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
            String string = this.multiselectRawValue = this.isMultiselect() && this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
        }
        if (this.cursorBinding != null && (cursor = valueChange.getIntAttribute(CURSOR)) != null && !Objects.equals(this.cursor, cursor)) {
            this.updateBindingForValue(cursor, this.cursorBinding, this.cursorBinding.getBindingExpression(), this.getOptionalFormatter());
            this.cursor = cursor;
        }
    }

    protected void updateFilterTextBinding() {
        if (this.filterTextBinding != null) {
            this.updateBindingForValue(this.filterText, this.filterTextBinding, this.filterText);
        }
    }

    protected void selectItemByFilterText() {
        if (this.filteredObjectValues.size() == 1 && ((List)((Map.Entry)this.filteredObjectValues.entrySet().iterator().next()).getValue()).size() == 1) {
            for (Map.Entry entry : this.collectValues(this.filteredObjectValues).entrySet()) {
                for (ComboItemDTO item : (List)entry.getValue()) {
                    if (!Objects.equals(this.filterText, item.isDisplayAsTarget() ? item.getTargetValue() : item.getDisplayedValue())) continue;
                    this.selectedItemIndex = ((List)entry.getValue()).indexOf(item);
                    this.selectedItem = ((List)this.filteredObjectValues.get(entry.getKey())).get(this.selectedItemIndex);
                    this.rawValue = this.toRawValue(this.selectedItem);
                    return;
                }
            }
        }
    }

    @Override
    public void validate() {
        if (this.getModelBinding() != null && this.getModelBinding().getBindingResult() != null) {
            this.validConversion = this.multiselect || Objects.equals(StringUtils.nullToEmpty((String)this.filterText), StringUtils.nullToEmpty((String)this.rawValue));
            ValidationManager<Combo> vm = ValidationFactory.getInstance().getComboValidationProcess();
            List formComponentValidationResult = vm.validate((Object)this);
            IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
            BindingResult bindingResult = this.getModelBinding().getBindingResult();
            formComponentValidationResult.stream().forEach(x -> validationResults.addCustomMessageForComponent((IValidatedComponent)this, bindingResult.getParent(), bindingResult.getAttributeName(), x.getMessage(), PresentationStyleEnum.BLOCKER));
        }
    }

    @Override
    public void prepareComponentAfterValidation(ElementChanges elementChanges) {
        List fieldValidationResultFor;
        IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
        BindingResult bindingResult = this.getModelBinding() != null ? this.getModelBinding().getBindingResult() : null;
        List list = fieldValidationResultFor = bindingResult == null ? Collections.emptyList() : validationResults.getFieldValidationResultFor(bindingResult.getParent(), bindingResult.getAttributeName());
        if (this.getAvailability() != AccessibilityEnum.EDIT) {
            fieldValidationResultFor.removeIf(FieldValidationResult::isFormSource);
        }
        this.processStylesAndHints(elementChanges, fieldValidationResultFor);
    }

    @Override
    protected FormFieldHints processPresentationStyle(ElementChanges elementChanges, List<FieldValidationResult> fieldValidationResults) {
        BindingResult bindingResult;
        PresentationStyleEnum oldPresentationStyle = this.getPresentationStyle();
        FormFieldHints formFieldHints = null;
        BindingResult bindingResult2 = bindingResult = this.getModelBinding() != null ? this.getModelBinding().getBindingResult() : null;
        if (bindingResult != null) {
            formFieldHints = this.calculatePresentationStyle(this.getModelBinding().getBindingResult());
            this.setPresentationStyle(formFieldHints != null ? formFieldHints.getPresentationStyleEnum() : null);
        } else {
            this.setPresentationStyle(null);
        }
        if (!(fieldValidationResults.isEmpty() || this.getPresentationStyle() != null && this.getPresentationStyle() == PresentationStyleEnum.BLOCKER)) {
            this.setPresentationStyle(PresentationStyleEnum.BLOCKER);
        }
        if (oldPresentationStyle != this.getPresentationStyle()) {
            elementChanges.addChange("presentationStyle", (Object)this.getPresentationStyle());
        }
        return formFieldHints;
    }

    @Override
    @JsonIgnore
    public List<ModelBinding> getAllBingings() {
        ArrayList<ModelBinding> allBindings = new ArrayList<ModelBinding>();
        allBindings.add(this.getModelBinding());
        allBindings.add(this.getLabelModelBinding());
        allBindings.add(this.getModelBinding());
        return allBindings;
    }

    private String getFormatterName() {
        Optional<String> formatter = this.getOptionalFormatter();
        return formatter.isPresent() ? formatter.get() : "";
    }

    protected void changeSelectedItemBinding() {
        if (this.getModelBinding() != null) {
            if (this.isMultiselect() && this.getModelBinding().getBindingResult() != null) {
                if (this.getModelBinding().getBindingResult().getValue() != null) {
                    if (this.selectedItem != null) {
                        ((List)this.getModelBinding().getBindingResult().getValue()).add(this.selectedItem);
                    } else {
                        ((List)this.getModelBinding().getBindingResult().getValue()).clear();
                    }
                } else {
                    this.getModelBinding().setValue(this.selectedItem);
                }
                this.selectedItem = new ArrayList((List)this.getModelBinding().getBindingResult().getValue());
            } else if (this.selectedItem instanceof IComboItem) {
                this.getModelBinding().setValue((Object)((IComboItem)this.selectedItem).getTargetValue());
            } else {
                this.getModelBinding().setValue(this.selectedItem);
            }
        }
    }

    protected void processFiltering(String text) {
        Map<String, List> filtered = this.values.entrySet().stream().filter(a -> ((List)a.getValue()).stream().anyMatch(b -> this.filterFunction.test(b, text))).collect(Collectors.toMap(Map.Entry::getKey, p -> ((List)p.getValue()).stream().filter(s -> this.filterFunction.test(s, text)).collect(Collectors.toList())));
        this.filteredObjectValues.clear();
        this.filteredObjectValues.putAll(filtered);
        this.filterInvoked = true;
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        boolean selectedBindingChanged = elementChanges.getChangedAttributes().containsKey("rawValue");
        if (this.freeTypingBinding != null) {
            this.freeTyping = this.freeTypingBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.freeTyping, FREE_TYPING);
        }
        if (this.emptyValueBinding != null) {
            this.emptyValue = this.emptyValueBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.emptyValue, EMPTY_VALUE_ATTR);
        }
        if (this.cleared) {
            this.filterText = "";
            this.updateFilterTextBinding();
            this.processFiltering(this.filterText);
        }
        this.processFilterTextBinding(elementChanges);
        this.setFilterFunction();
        this.refreshAvailability(elementChanges);
        boolean valuesChanged = this.processValuesBinding();
        if (selectedBindingChanged || valuesChanged) {
            this.processFiltering(this.filterText);
        }
        this.processFilterBinding(elementChanges, valuesChanged);
        this.processLabelBinding(elementChanges);
        this.processCursorBinding((FormElement)this, elementChanges);
        this.prepareComponentAfterValidation(elementChanges);
        if (elementChanges.containsAnyChanges()) {
            this.refreshView();
        }
        this.cleared = false;
        return elementChanges;
    }

    private void processFilterTextBinding(ElementChanges elementChanges) {
        BindingResult filterTextResult;
        if (!(this.getModelBinding() != null && this.getModelBinding().getBindingResult() != null && this.getModelBinding().getBindingResult().getValue() != null || this.getFilterTextBinding() == null || Objects.equals((filterTextResult = this.getFilterTextBinding().getBindingResult()).getValue(), this.filterText))) {
            this.rawValue = this.filterText = StringUtils.nullToEmpty((String)((String)filterTextResult.getValue()));
            elementChanges.addChange("rawValue", (Object)this.rawValue);
            this.processFiltering(this.filterText);
            if (!StringUtils.isNullOrEmpty((String)this.filterText)) {
                this.cursor = this.filterText.length();
                if (this.cursorBinding != null) {
                    this.updateBindingForValue(this.cursor, this.cursorBinding, this.cursorBinding.getBindingExpression(), this.getOptionalFormatter());
                }
            }
        }
    }

    private void setFilterFunction() {
        BindingResult filterBindingResult = this.getFilterFunctionBinding() != null ? this.getFilterFunctionBinding().getBindingResult() : null;
        this.filterFunction = filterBindingResult != null ? (BiPredicate<Object, Object>)filterBindingResult.getValue() : (model, value) -> this.objectToString(model).toLowerCase().contains(value.toLowerCase());
    }

    protected boolean processValuesBinding() {
        BindingResult valuesBindingResult;
        boolean valuesChanged = false;
        if (this.valuesBinding != null && (valuesBindingResult = this.valuesBinding.getBindingResult()) != null) {
            Object value = valuesBindingResult.getValue();
            if (value instanceof String) {
                String valuesAsString = (String)value;
                String[] allValues = valuesAsString.split("\\|");
                if (allValues.length > 0) {
                    LinkedMultiValueMap newValues = new LinkedMultiValueMap();
                    newValues.put((Object)"", Arrays.stream(allValues).collect(Collectors.toList()));
                    if (!Objects.equals(newValues, this.values)) {
                        this.values.clear();
                        this.values.putAll((Map)newValues);
                        return true;
                    }
                }
            } else if (value instanceof List) {
                List collection = (List)value;
                if (!CollectionUtils.isEmpty((Collection)collection)) {
                    this.modelType = collection.stream().findFirst().get().getClass();
                }
                LinkedMultiValueMap newValues = new LinkedMultiValueMap();
                newValues.put((Object)"", new LinkedList(collection));
                if (!Objects.equals(newValues, this.values)) {
                    this.values.clear();
                    this.values.putAll((Map)newValues);
                    return true;
                }
            } else if (value instanceof MultiValueMap && !Objects.equals(value, this.values)) {
                MultiValueMap mapFromBinding = (MultiValueMap)value;
                this.resolveModelType((MultiValueMap<String, Object>)mapFromBinding);
                mapFromBinding.entrySet().stream().forEach(entry -> {
                    List cfr_ignored_0 = (List)this.values.put(entry.getKey(), new LinkedList((Collection)entry.getValue()));
                });
                return true;
            }
        }
        return valuesChanged;
    }

    private void resolveModelType(MultiValueMap<String, Object> mapFromBinding) {
        Set entries = mapFromBinding.entrySet();
        for (Map.Entry entry : entries) {
            List values = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            this.modelType = values.get(0).getClass();
            return;
        }
    }

    protected boolean processFilterBinding(ElementChanges elementChanges, boolean valuesChanged) {
        if (!this.preload && this.firstLoad && StringUtils.isNullOrEmpty((String)this.filterText) && !valuesChanged && !this.cleared) {
            return false;
        }
        if (this.filterInvoked || valuesChanged) {
            this.filteredValues = this.collectValues(this.filteredObjectValues);
            elementChanges.addChange(FILTERED_VALUES, this.filteredValues);
            this.filterInvoked = false;
            return true;
        }
        return false;
    }

    @Override
    protected boolean processValueBinding(ElementChanges elementChanges) {
        Object value;
        BindingResult selectedBindingResult;
        if (this.getModelBinding() != null && (selectedBindingResult = this.getModelBinding().getBindingResult()) != null && !Objects.equals(value = selectedBindingResult.getValue(), this.selectedItem)) {
            this.selectedItem = value;
            if (this.isMultiselect()) {
                this.selectedItem = new ArrayList((List)value);
                this.multiselectRawValue = this.toRawValue(value);
                elementChanges.addChange(MULTISELECT_RAW_VALUE_ATTR, (Object)this.multiselectRawValue);
            } else {
                this.rawValue = this.toRawValue(value);
                elementChanges.addChange("rawValue", (Object)this.rawValue);
            }
            this.filterText = this.rawValue != null ? this.rawValue : "";
            this.updateFilterTextBinding();
            return true;
        }
        return false;
    }

    protected MultiValueMap<String, ComboItemDTO> collectValues(MultiValueMap<String, Object> valuesToConvert) {
        LinkedMultiValueMap filteredConvertedValues = new LinkedMultiValueMap();
        AtomicReference<Long> idx = new AtomicReference<Long>(0L);
        valuesToConvert.forEach((arg_0, arg_1) -> this.lambda$collectValues$8(idx, (MultiValueMap)filteredConvertedValues, arg_0, arg_1));
        return filteredConvertedValues;
    }

    protected String toRawValue(Object s) {
        if (s instanceof List) {
            return JsonUtil.writeValue(((List)s).stream().map(this::toRawElementValue).collect(Collectors.toList()));
        }
        return this.toRawElementValue(s);
    }

    private String toRawElementValue(Object s) {
        if (s instanceof IComboItem) {
            return ((IComboItem)s).getTargetValue();
        }
        return this.objectToString(s);
    }

    protected String objectToString(Object s) {
        Optional<String> formatter = this.getOptionalFormatter();
        if (formatter.isPresent()) {
            return this.convertValueToString(s, formatter.get());
        }
        if (this.displayFunctionBinding != null && s != null) {
            return this.objectToStringAsDisplayFunction(s);
        }
        if (this.displayExpression != null && s != null) {
            return this.objectToStringAsDisplayExpresssion(s);
        }
        return this.convertValueToString(s, "");
    }

    @Override
    protected String convertToRaw(BindingResult<?> bindingResult) {
        Object value;
        Object object = value = bindingResult == null ? null : bindingResult.getValue();
        if (value == null) {
            return "";
        }
        return this.toRawValue(value);
    }

    private String objectToStringAsDisplayExpresssion(Object item) {
        if (item == null) {
            return null;
        }
        if (item instanceof String) {
            return (String)item;
        }
        if (this.displayExpressionFunction == null) {
            Expression exp = SpelUtils.parseExpression((String)this.displayExpression);
            this.displayExpressionFunction = obj -> this.convertValueToString(SpelUtils.evaluateExpression((Expression)exp, (Object)obj));
        }
        return this.displayExpressionFunction.apply(item);
    }

    private String objectToStringAsDisplayFunction(Object s) {
        BindingResult bindingResult = this.displayFunctionBinding.getBindingResult();
        if (bindingResult == null) {
            throw new FhBindingException("No binding function for " + this.displayFunctionBinding.getBindingExpression());
        }
        Function function = (Function)bindingResult.getValue();
        if (function == null) {
            throw new FhBindingException("No binding function for " + this.displayFunctionBinding.getBindingExpression());
        }
        return (String)function.apply(s);
    }

    public Optional<String> getOptionalFormatter() {
        return Optional.ofNullable(this.formatter);
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    private boolean processCursorBinding(FormElement formElement, ElementChanges elementChanges) {
        if (this.getCursorBinding() != null) {
            Integer newValue;
            BindingResult bindingResult;
            Integer oldValue = this.getCursor();
            if (this.getCursorBinding() != null && (bindingResult = this.getCursorBinding().getBindingResult()) != null && bindingResult.getValue() != null && !formElement.areValuesTheSame((Object)(newValue = Integer.valueOf((Integer)bindingResult.getValue())), (Object)oldValue)) {
                formElement.refreshView();
                elementChanges.addChange(CURSOR, (Object)newValue);
                this.cursor = newValue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Combo createNewSameComponent() {
        return new Combo(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        Combo clone = (Combo)baseClone;
        clone.setOnInput(table.getRowBinding(this.getOnInput(), (Component)clone, iteratorReplacements));
        clone.setOnEmptyValue(table.getRowBinding(this.getOnEmptyValue(), (Component)clone, iteratorReplacements));
        clone.setOnSpecialKey(table.getRowBinding(this.getOnSpecialKey(), (Component)clone, iteratorReplacements));
        clone.setOnDblSpecialKey(table.getRowBinding(this.getOnDblSpecialKey(), (Component)clone, iteratorReplacements));
        clone.setValuesBinding(table.getRowBinding(this.getValuesBinding(), (Component)clone, iteratorReplacements));
        clone.setFilterFunctionBinding(table.getRowBinding(this.getFilterFunctionBinding(), (Component)clone, iteratorReplacements));
        clone.setDisplayFunctionBinding(table.getRowBinding(this.getDisplayFunctionBinding(), (Component)clone, iteratorReplacements));
        clone.setDisplayExpression(this.getDisplayExpression());
        clone.setEmptyValueBinding((ModelBinding<Boolean>)table.getRowBinding(this.getEmptyValueBinding(), (Component)clone, iteratorReplacements));
        clone.setPreload(this.isPreload());
        clone.setFormatter(this.getFormatter());
        clone.setFreeTypingBinding((ModelBinding<Boolean>)table.getRowBinding(this.getFreeTypingBinding(), (Component)clone, iteratorReplacements));
        clone.setCursorBinding(table.getRowBinding(this.getCursorBinding(), (Component)clone, iteratorReplacements));
    }

    public void setOnInput(ActionBinding onInput) {
        this.onInput = onInput;
    }

    public IActionCallbackContext setOnInput(IActionCallback onInput) {
        return CallbackActionBinding.createAndSet((IActionCallback)onInput, this::setOnInput);
    }

    public void setOnEmptyValue(ActionBinding onEmptyValue) {
        this.onEmptyValue = onEmptyValue;
    }

    public IActionCallbackContext setOnEmptyValue(IActionCallback onEmptyValue) {
        return CallbackActionBinding.createAndSet((IActionCallback)onEmptyValue, this::setOnEmptyValue);
    }

    public void setOnSpecialKey(ActionBinding onSpecialKey) {
        this.onSpecialKey = onSpecialKey;
    }

    public void setOnDblSpecialKey(ActionBinding onDblSpecialKey) {
        this.onDblSpecialKey = onDblSpecialKey;
    }

    public IActionCallbackContext setOnSpecialKey(IActionCallback onSpecialKey) {
        return CallbackActionBinding.createAndSet((IActionCallback)onSpecialKey, this::setOnSpecialKey);
    }

    public Boolean getOpenOnFocus() {
        return this.openOnFocus;
    }

    public void setOpenOnFocus(Boolean openOnFocus) {
        this.openOnFocus = openOnFocus;
    }

    public void setOnInputTimeout(Integer onInputTimeout) {
        this.onInputTimeout = onInputTimeout;
    }

    public Integer getOnInputTimeout() {
        return this.onInputTimeout;
    }

    public ActionBinding getOnInput() {
        return this.onInput;
    }

    public ActionBinding getOnEmptyValue() {
        return this.onEmptyValue;
    }

    public ActionBinding getOnSpecialKey() {
        return this.onSpecialKey;
    }

    public ActionBinding getOnDblSpecialKey() {
        return this.onDblSpecialKey;
    }

    @Override
    public String getRawValue() {
        return this.rawValue;
    }

    public ModelBinding getFilterTextBinding() {
        return this.filterTextBinding;
    }

    public void setFilterTextBinding(ModelBinding filterTextBinding) {
        this.filterTextBinding = filterTextBinding;
    }

    public MultiValueMap<String, ComboItemDTO> getFilteredValues() {
        return this.filteredValues;
    }

    public ModelBinding getValuesBinding() {
        return this.valuesBinding;
    }

    public void setValuesBinding(ModelBinding valuesBinding) {
        this.valuesBinding = valuesBinding;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    public ModelBinding getFilterFunctionBinding() {
        return this.filterFunctionBinding;
    }

    public void setFilterFunctionBinding(ModelBinding filterFunctionBinding) {
        this.filterFunctionBinding = filterFunctionBinding;
    }

    public boolean isEmptyValue() {
        return this.emptyValue;
    }

    public ModelBinding<Boolean> getEmptyValueBinding() {
        return this.emptyValueBinding;
    }

    public void setEmptyValueBinding(ModelBinding<Boolean> emptyValueBinding) {
        this.emptyValueBinding = emptyValueBinding;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public boolean isFreeTyping() {
        return this.freeTyping;
    }

    public boolean isMultiselect() {
        return this.multiselect;
    }

    public void setMultiselect(boolean multiselect) {
        this.multiselect = multiselect;
    }

    public Integer getWidthRatio() {
        return this.widthRatio;
    }

    public void setWidthRatio(Integer widthRatio) {
        this.widthRatio = widthRatio;
    }

    public String getMultiselectRawValue() {
        return this.multiselectRawValue;
    }

    public ModelBinding<Boolean> getFreeTypingBinding() {
        return this.freeTypingBinding;
    }

    public void setFreeTypingBinding(ModelBinding<Boolean> freeTypingBinding) {
        this.freeTypingBinding = freeTypingBinding;
    }

    public ModelBinding getCursorBinding() {
        return this.cursorBinding;
    }

    public void setCursorBinding(ModelBinding cursorBinding) {
        this.cursorBinding = cursorBinding;
    }

    public ModelBinding getDisplayFunctionBinding() {
        return this.displayFunctionBinding;
    }

    public void setDisplayFunctionBinding(ModelBinding displayFunctionBinding) {
        this.displayFunctionBinding = displayFunctionBinding;
    }

    public String getDisplayExpression() {
        return this.displayExpression;
    }

    public void setDisplayExpression(String displayExpression) {
        this.displayExpression = displayExpression;
    }

    public Function<Object, String> getDisplayExpressionFunction() {
        return this.displayExpressionFunction;
    }

    public void setDisplayExpressionFunction(Function<Object, String> displayExpressionFunction) {
        this.displayExpressionFunction = displayExpressionFunction;
    }

    public Integer getCursor() {
        return this.cursor;
    }

    private /* synthetic */ void lambda$collectValues$8(AtomicReference idx, MultiValueMap filteredConvertedValues, String key, List values) {
        values.forEach(value -> {
            ComboItemDTO item;
            if (value instanceof IComboItem) {
                item = new ComboItemDTO((IComboItem)value);
                item.targetId = (Long)idx.get();
            } else {
                item = new ComboItemDTO(this.objectToString(value), (Long)idx.get());
            }
            idx.getAndSet((Long)idx.get() + 1L);
            filteredConvertedValues.add((Object)key, (Object)item);
        });
    }

    protected static class ComboItemDTO {
        private boolean displayAsTarget;
        private Object targetValue;
        private String displayedValue;
        private Integer targetCursorPosition;
        private Long targetId;
        private String displayedValueWithoutExtras;

        public ComboItemDTO(String targetValue, Long targetId) {
            this.displayAsTarget = true;
            this.targetValue = targetValue;
            this.targetId = targetId;
        }

        public ComboItemDTO(Object targetValue, Long targetId, boolean displayAsTarget, String displayedValue) {
            this.displayAsTarget = displayAsTarget;
            this.targetValue = targetValue;
            this.targetId = targetId;
            this.displayedValue = displayedValue;
        }

        public ComboItemDTO(IComboItem comboItem) {
            this.displayAsTarget = false;
            this.targetValue = comboItem.getTargetValue();
            this.targetId = comboItem.getTargetId();
            this.displayedValue = comboItem.getDisplayedValue();
            this.targetCursorPosition = comboItem.getTargetCursorPosition();
            this.displayedValueWithoutExtras = comboItem.getFullHintWithoutExtras();
        }

        public boolean isDisplayAsTarget() {
            return this.displayAsTarget;
        }

        public Object getTargetValue() {
            return this.targetValue;
        }

        public String getDisplayedValue() {
            return this.displayedValue;
        }

        public Integer getTargetCursorPosition() {
            return this.targetCursorPosition;
        }

        public Long getTargetId() {
            return this.targetId;
        }

        public String getDisplayedValueWithoutExtras() {
            return this.displayedValueWithoutExtras;
        }
    }
}

