/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.springframework.util.StringUtils;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.OutputLabel;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.model.LabelPosition;

@DesignerControl(defaultWidth=2)
@Control(parents={PanelGroup.class, Group.class, Column.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.BUTTONS_AND_OTHER, documentationExample=true, value="Label component is responsible for displaying HTML link.", icon="fa fa-link")
public class Link
extends OutputLabel
implements IHasBoundableLabel {
    private static final String ATTR_URL = "url";
    protected static final String LABEL_ATTR = "label";
    @XMLProperty(defaultValue="true", required=true)
    @DocumentedComponentAttribute(defaultValue="true", value="If url is provided, then user can set if link should be displayed in new window")
    private boolean newWindow = true;
    private String url;
    @JsonIgnore
    @XMLProperty(required=true, value="url")
    @DesignerXMLProperty(commonUse=true, allowedTypes={String.class})
    @DocumentedComponentAttribute(boundable=true, value="Hyperlink to resource")
    private ModelBinding<String> urlBinding;
    private String label = "";
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component. Supports FHML - Fh Markup Language.")
    private ModelBinding labelModelBinding;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=95)
    @DocumentedComponentAttribute(value="Defines position of a label. Position is one of: up, down, left, right.")
    private LabelPosition labelPosition;

    public Link(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        this.calculateAndSetDefaultSize();
    }

    private void calculateAndSetDefaultSize() {
        if (!StringUtils.hasText((String)this.getWidth())) {
            this.setWidth("md-12");
        }
    }

    private void processURL(ElementChanges elementChanges) {
        if (this.urlBinding == null) {
            return;
        }
        this.url = this.urlBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.url, ATTR_URL);
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.processLabelBinding(elementChanges);
        this.processURL(elementChanges);
        return elementChanges;
    }

    private void processLabelBinding(ElementChanges elementChanges) {
        String newLabelValue;
        BindingResult labelBidingResult = this.labelModelBinding != null ? this.labelModelBinding.getBindingResult() : null;
        String string = newLabelValue = labelBidingResult == null ? null : this.convertBindingValueToString(labelBidingResult);
        if (!this.areValuesTheSame(newLabelValue, this.label)) {
            this.label = newLabelValue;
            elementChanges.addChange(LABEL_ATTR, (Object)this.label);
        }
    }

    @Override
    public Link createNewSameComponent() {
        return new Link(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, OutputLabel baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        Link clone = (Link)baseClone;
        clone.setUrlBinding((ModelBinding<String>)table.getRowBinding(this.getUrlBinding(), (Component)clone, iteratorReplacements));
        clone.setLabelModelBinding(table.getLabelModelBinding());
        clone.setLabelPosition(this.getLabelPosition());
        clone.setNewWindow(this.isNewWindow());
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public void setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
    }

    public String getUrl() {
        return this.url;
    }

    public ModelBinding<String> getUrlBinding() {
        return this.urlBinding;
    }

    public void setUrlBinding(ModelBinding<String> urlBinding) {
        this.urlBinding = urlBinding;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }
}

