/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import pl.fhframework.BindingResult;
import pl.fhframework.SessionManager;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhException;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.core.forms.IValidatedComponent;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.io.FileService;
import pl.fhframework.io.IFileMaxSized;
import pl.fhframework.io.IResourced;
import pl.fhframework.io.TemporaryResource;
import pl.fhframework.model.PresentationStyleEnum;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.AccessibilityEnum;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Styleable;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableComponent;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.ButtonStyleFixedValuesProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.utils.LanguageResolver;
import pl.fhframework.model.forms.validation.ValidationFactory;
import pl.fhframework.validation.FieldValidationResult;
import pl.fhframework.validation.FormFieldHints;
import pl.fhframework.validation.IValidationResults;
import pl.fhframework.validation.ValidationManager;

@DesignerControl(defaultWidth=2)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Component responsible for file upload", icon="fa fa-upload")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
public class FileUpload
extends FormElement
implements TableComponent<FileUpload>,
IChangeableByClient,
Boundable,
IValidatedComponent,
IFileMaxSized,
IResourced,
IHasBoundableLabel,
Styleable {
    private static final String REQUIRED_ATTR = "required";
    private static final String LABEL_ATTR = "label";
    public static final String STYLE_ATTR = "style";
    protected static final String VALIDATION_LABEL_ATTR = "validationLabel";
    private static final String MESSAGE_FOR_FIELD_ATTR = "messageForField";
    private static final String ON_UPLOAD_ATTR = "onUpload";
    private static final String FILE_NAMES_ATTR = "fileNames";
    private static final String FILE_ATTR = "file";
    private static final String FILES_ATTR = "files";
    private static final String FILE_IDS_ATTR = "fileIds";
    private static final String MULTIPLE_ATTR = "multiple";
    private static final String MAX_SIZE_ATTR = "maxSize";
    private static final String LABEL_HIDDEN_ATTR = "labelHidden";
    private static final String EXTENSIONS_ATTR = "extensions";
    @Autowired
    @JsonIgnore
    private FileService fileService;
    @XMLProperty(defaultValue="-")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="Action which will be executed after file is uploaded.", defaultValue="-")
    private ActionBinding onUpload;
    @JsonIgnore
    private List<String> fileNames;
    @JsonIgnore
    @XMLProperty(value="file")
    @DesignerXMLProperty(allowedTypes={Resource.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, commonUse=true)
    @DocumentedComponentAttribute(value="Binding for file.")
    private ModelBinding fileModelBinding;
    @JsonIgnore
    @XMLProperty(value="files")
    @DesignerXMLProperty(allowedTypes={List.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, commonUse=true)
    @DocumentedComponentAttribute(value="Binding for multiple files.")
    private ModelBinding filesModelBinding;
    @JsonIgnore
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="User can define if component is required for Form.")
    private boolean required;
    @XMLProperty(defaultValue="1000000")
    @DocumentedComponentAttribute(defaultValue="1000000", value="Maximum allowed size of uploaded file in bytes. The maximum file size depends on the configuration of the server. This information should be obtained from the system administrator.")
    private long maxSize = 1000000L;
    private String label = "";
    private Styleable.Style style = Styleable.Style.PRIMARY;
    @JsonIgnore
    @XMLProperty(value="extensions")
    @DocumentedComponentAttribute(value="Defines what file extensions are allowed for upload (comma separated list of extensions e.g. .xml,.txt).", boundable=true)
    private ModelBinding<String> extensionsBinding;
    private String extensions;
    @XMLProperty
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component.")
    private boolean labelHidden;
    @XMLProperty
    @DocumentedComponentAttribute(boundable=true, value="Is multiple file upload allowed.")
    private boolean multiple;
    @JsonIgnore
    @XMLProperty(value="style")
    @DocumentedComponentAttribute(boundable=true, defaultValue="primary", value="Determines style of FileUpload button. It is possible to select one of six Bootstrap classes: default, primary, success, info, warning, danger or bind it with variable.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=77, fixedValuesProvider=ButtonStyleFixedValuesProvider.class)
    private ModelBinding styleModelBinding;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component.")
    private ModelBinding labelModelBinding;
    @JsonIgnore
    @XMLProperty(value="validationLabel")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Represents label for created component used in validation messages. If not set, falls back to label attribute's value.")
    private ModelBinding validationLabelModelBinding;
    private PresentationStyleEnum presentationStyle;
    private String messageForField = "";
    private String language;

    public FileUpload(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        AutowireHelper.autowire((Object)this, (Object[])new Object[]{this.fileService});
    }

    @Override
    public FileUpload createNewSameComponent() {
        return new FileUpload(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, FileUpload clone) {
        TableComponent.super.doCopy(table, iteratorReplacements, clone);
        clone.setOnUpload(table.getRowBinding(this.getOnUpload(), (Component)clone, iteratorReplacements));
        clone.setFileModelBinding(table.getRowBinding(this.getFileModelBinding(), (Component)clone, iteratorReplacements));
        clone.setFilesModelBinding(table.getRowBinding(this.getFilesModelBinding(), (Component)clone, iteratorReplacements));
        clone.setRequired(this.isRequired());
        clone.setMaxSize(this.getMaxSize());
        clone.setExtensionsBinding((ModelBinding<String>)table.getRowBinding(this.getExtensionsBinding(), (Component)clone, iteratorReplacements));
        clone.setLabelHidden(this.isLabelHidden());
        clone.setMultiple(this.isMultiple());
        clone.setLabelModelBinding(table.getRowBinding(this.getLabelModelBinding(), (Component)clone, iteratorReplacements));
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_UPLOAD_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onUpload);
        }
        return super.getEventHandler(eventData);
    }

    public void updateModel(ValueChange valueChange) {
        List fileIds = valueChange.getStringListAttribute(FILE_IDS_ATTR);
        if (this.multiple) {
            ArrayList tempResources = new ArrayList();
            fileIds.forEach(c -> {
                TemporaryResource tempResource = this.fileService.getResource(c, SessionManager.getUserSession());
                tempResources.add(tempResource);
            });
            if (this.filesModelBinding == null) {
                throw new FhException("Files container binding not set. Please bind resource to {files} option.");
            }
            this.filesModelBinding.setValue(tempResources);
        } else {
            TemporaryResource tempResource = this.fileService.getResource((String)fileIds.get(0), SessionManager.getUserSession());
            if (this.fileModelBinding == null) {
                throw new FhException("File container binding not set. Please bind resource to {file} option.");
            }
            this.fileModelBinding.setValue((Object)tempResource);
        }
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        if (this.fileModelBinding != null || this.filesModelBinding != null) {
            this.skipSettingPresentation(elementChanges, this.getForm());
        }
        if (this.extensionsBinding != null) {
            this.extensions = this.extensionsBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.extensions, EXTENSIONS_ATTR);
        }
        this.language = LanguageResolver.languageChanges(this.getForm().getAbstractUseCase().getUserSession(), this.language, elementChanges);
        if (this.labelModelBinding != null) {
            String newLabelValue;
            Object newLabelValueObj = this.labelModelBinding.getBindingResult().getValue();
            String string = newLabelValue = newLabelValueObj != null ? newLabelValueObj.toString() : null;
            if (!this.areValuesTheSame(newLabelValue, this.label)) {
                this.label = newLabelValue;
                elementChanges.addChange(LABEL_ATTR, (Object)this.label);
            }
        }
        boolean refreshView = this.processStyleBinding(elementChanges, false);
        refreshView = this.processFileNameBinding(elementChanges, refreshView);
        this.prepareComponentAfterValidation(elementChanges);
        if (refreshView) {
            this.refreshView();
        }
        return elementChanges;
    }

    protected boolean processStyleBinding(ElementChanges elementChanges, boolean refreshView) {
        String newLabelValue;
        BindingResult labelBidingResult;
        BindingResult bindingResult = labelBidingResult = this.styleModelBinding != null ? this.styleModelBinding.getBindingResult() : null;
        if (labelBidingResult != null && !this.areValuesTheSame(newLabelValue = this.convertBindingValueToString(labelBidingResult), this.style.toValue())) {
            this.style = Styleable.Style.forValue(newLabelValue);
            elementChanges.addChange(STYLE_ATTR, (Object)this.style);
            refreshView = true;
        }
        return refreshView;
    }

    private boolean processFileNameBinding(ElementChanges elementChanges, boolean refreshView) {
        BindingResult labelBindingResult;
        if (!this.multiple && this.fileModelBinding != null && (labelBindingResult = this.fileModelBinding.getBindingResult()) != null) {
            String resourceName;
            Resource resource = (Resource)labelBindingResult.getValue();
            String string = resourceName = resource == null ? "" : resource.getFilename();
            if (!this.areValuesTheSame(resourceName, this.fileNames)) {
                this.fileNames = Collections.singletonList(resourceName);
                elementChanges.addChange(FILE_NAMES_ATTR, this.fileNames);
                refreshView = true;
            }
        }
        if (this.multiple && this.filesModelBinding != null && (labelBindingResult = this.filesModelBinding.getBindingResult()) != null) {
            ArrayList<String> resourceNames;
            List resources = (List)labelBindingResult.getValue();
            List<String> list = resourceNames = resources == null ? new ArrayList<String>() : resources.stream().map(Resource::getFilename).collect(Collectors.toList());
            if (!this.areValuesTheSame(resourceNames, this.fileNames)) {
                this.fileNames = resourceNames;
                elementChanges.addChange(FILE_NAMES_ATTR, this.fileNames);
                refreshView = true;
            }
        }
        return refreshView;
    }

    public void validate() {
        ValidationManager<FileUpload> vm = ValidationFactory.getInstance().getFileUploadValidationProcess();
        List formComponentValidationResult = vm.validate((Object)this);
        IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
        formComponentValidationResult.forEach(x -> {
            BindingResult bindingResult = this.getModelBinding().getBindingResult();
            validationResults.addCustomMessageForComponent((IValidatedComponent)this, bindingResult.getParent(), bindingResult.getAttributeName(), x.getMessage(), PresentationStyleEnum.BLOCKER);
        });
    }

    public void prepareComponentAfterValidation(ElementChanges elementChanges) {
        if (this.getForm().getAbstractUseCase() != null) {
            List fieldValidationResultFor;
            IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
            BindingResult bindingResult = this.getModelBinding() != null ? this.getModelBinding().getBindingResult() : null;
            List list = fieldValidationResultFor = bindingResult == null ? Collections.emptyList() : validationResults.getFieldValidationResultFor(bindingResult.getParent(), bindingResult.getAttributeName());
            if (this.getAvailability() != AccessibilityEnum.EDIT) {
                fieldValidationResultFor.removeIf(FieldValidationResult::isFormSource);
            }
            this.processStylesAndHints(elementChanges, fieldValidationResultFor);
        }
    }

    public ModelBinding getModelBinding() {
        return this.multiple ? this.getFilesModelBinding() : this.getFileModelBinding();
    }

    protected void processStylesAndHints(ElementChanges elementChanges, List<FieldValidationResult> fieldValidationResults) {
        FormFieldHints formFieldHints = this.processPresentationStyle(elementChanges, fieldValidationResults);
        this.processMessagesForHints(elementChanges, formFieldHints);
    }

    private FormFieldHints processPresentationStyle(ElementChanges elementChanges, List<FieldValidationResult> fieldValidationResults) {
        PresentationStyleEnum oldPresentationStyle = this.presentationStyle;
        FormFieldHints formFieldHints = null;
        this.presentationStyle = this.getModelBinding() != null && this.getModelBinding().getBindingResult() != null ? ((formFieldHints = this.calculatePresentationStyle(this.getModelBinding().getBindingResult())) != null ? formFieldHints.getPresentationStyleEnum() : null) : null;
        if (!(fieldValidationResults.isEmpty() || this.presentationStyle != null && this.presentationStyle == PresentationStyleEnum.BLOCKER)) {
            this.presentationStyle = PresentationStyleEnum.BLOCKER;
        }
        if (oldPresentationStyle != this.presentationStyle) {
            elementChanges.addChange("presentationStyle", (Object)this.presentationStyle);
        }
        return formFieldHints;
    }

    private FormFieldHints calculatePresentationStyle(BindingResult bindingResult) {
        if (bindingResult.getParent() != null && bindingResult.getAttributeName() != null && this.getAvailability() == AccessibilityEnum.EDIT) {
            return this.getForm().getAbstractUseCase().getUserSession().getValidationResults().getPresentationStyleForField(bindingResult.getParent(), bindingResult.getAttributeName());
        }
        return null;
    }

    private void processMessagesForHints(ElementChanges elementChanges, FormFieldHints formFieldHints) {
        if (formFieldHints == null) {
            return;
        }
        String oldHints = this.messageForField;
        this.messageForField = formFieldHints.getHints();
        if (!Objects.equals(oldHints, this.messageForField) || oldHints != null && !oldHints.equals(this.messageForField) || this.messageForField != null && !this.messageForField.equals(oldHints)) {
            elementChanges.addChange(MESSAGE_FOR_FIELD_ATTR, (Object)this.messageForField);
        }
    }

    public void setOnUpload(ActionBinding onUpload) {
        this.onUpload = onUpload;
    }

    public IActionCallbackContext setOnUpload(IActionCallback onUpload) {
        return CallbackActionBinding.createAndSet((IActionCallback)onUpload, this::setOnUpload);
    }

    @JsonIgnore
    public Resource getResource() throws FileNotFoundException {
        Object value = this.getBindingResult(this.fileModelBinding);
        if (value != null && ClassUtils.isAssignableValue(Resource.class, (Object)value)) {
            return (Resource)value;
        }
        return null;
    }

    @JsonIgnore
    public List<Resource> getResources() throws FileNotFoundException {
        Object value = this.getBindingResult(this.filesModelBinding);
        if (value != null && ClassUtils.isAssignableValue(List.class, (Object)value)) {
            return (List)value;
        }
        return null;
    }

    private Object getBindingResult(ModelBinding binding) {
        BindingResult bindingResult;
        if (binding != null && (bindingResult = binding.getBindingResult()) != null) {
            return bindingResult.getValue();
        }
        return null;
    }

    protected List<ActionBinding> getAvailablityAffectingActions() {
        return Arrays.asList(this.onUpload);
    }

    public ActionBinding getOnUpload() {
        return this.onUpload;
    }

    public ModelBinding getFileModelBinding() {
        return this.fileModelBinding;
    }

    public void setFileModelBinding(ModelBinding fileModelBinding) {
        this.fileModelBinding = fileModelBinding;
    }

    public ModelBinding getFilesModelBinding() {
        return this.filesModelBinding;
    }

    public void setFilesModelBinding(ModelBinding filesModelBinding) {
        this.filesModelBinding = filesModelBinding;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public String getLabel() {
        return this.label;
    }

    public Styleable.Style getStyle() {
        return this.style;
    }

    public ModelBinding<String> getExtensionsBinding() {
        return this.extensionsBinding;
    }

    public void setExtensionsBinding(ModelBinding<String> extensionsBinding) {
        this.extensionsBinding = extensionsBinding;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public boolean isLabelHidden() {
        return this.labelHidden;
    }

    public void setLabelHidden(boolean labelHidden) {
        this.labelHidden = labelHidden;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public ModelBinding getStyleModelBinding() {
        return this.styleModelBinding;
    }

    public void setStyleModelBinding(ModelBinding styleModelBinding) {
        this.styleModelBinding = styleModelBinding;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public ModelBinding getValidationLabelModelBinding() {
        return this.validationLabelModelBinding;
    }

    public void setValidationLabelModelBinding(ModelBinding validationLabelModelBinding) {
        this.validationLabelModelBinding = validationLabelModelBinding;
    }

    public PresentationStyleEnum getPresentationStyle() {
        return this.presentationStyle;
    }

    public String getMessageForField() {
        return this.messageForField;
    }

    public String getLanguage() {
        return this.language;
    }
}

