/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pl.fhframework.binding.AdHocIndexedModelBinding;
import pl.fhframework.binding.IRowNumberOffsetSupplier;
import pl.fhframework.binding.RowNumberBindingContext;
import pl.fhframework.core.FhFormException;
import pl.fhframework.core.forms.iterators.IMultipleIteratorComponentFactory;
import pl.fhframework.core.forms.iterators.IRepeatableIteratorInfo;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableComponent;

public class AdHocTableColumnComponentFactory
implements IMultipleIteratorComponentFactory<Table> {
    private Column column;
    private Map<String, String> replacementTemplates;
    private String[] iteratorNameArray;
    private boolean initDone = false;

    public AdHocTableColumnComponentFactory(Column column) {
        this.column = column;
    }

    private void init() {
        this.replacementTemplates = AdHocIndexedModelBinding.buildIteratorReplacementTemplates(this.column.getIteratorInfos());
        this.iteratorNameArray = this.buildIteratorNameArray(this.column.getIteratorInfos());
        this.initDone = true;
    }

    public List<FormElement> createComponentsForIterators(Table myGroupingParent, IRowNumberOffsetSupplier rowNumberOffsetSupplier, int[] indices) {
        if (!this.initDone) {
            this.init();
        }
        Map replacements = AdHocIndexedModelBinding.fillIteratorReplacementTemplates(this.replacementTemplates, (int[])indices);
        ArrayList<FormElement> clonedComponents = new ArrayList<FormElement>();
        for (FormElement formElement : this.column.getPrototype().getSubcomponents()) {
            if (formElement instanceof TableComponent) {
                Object clone = ((TableComponent)formElement).getCopy(myGroupingParent, (Map<String, String>)replacements);
                this.setUpClonedFormComponent(myGroupingParent, (FormElement)clone, indices);
                clonedComponents.add((FormElement)clone);
                continue;
            }
            throw new FhFormException("Form component of class '" + formElement.getClass().getSimpleName() + "' could not be presented in table because it does not implement interface called 'TableComponent'!");
        }
        return clonedComponents;
    }

    private void setUpClonedFormComponent(Table owningTable, FormElement clone, int[] indices) {
        String uniqueIdSuffix = this.getMergedIdBasedOnIterators(indices);
        clone.setId(owningTable.getId() + uniqueIdSuffix + clone.getId());
        clone.setGroupingParentComponent((IGroupingComponent)owningTable);
        boolean isMainIterator = true;
        for (int i = 0; i < Math.min(indices.length, this.iteratorNameArray.length); ++i) {
            RowNumberBindingContext rowContext;
            if (isMainIterator) {
                rowContext = new RowNumberBindingContext(this.iteratorNameArray[i], indices[i] + 1, (IRowNumberOffsetSupplier)owningTable);
                isMainIterator = false;
            } else {
                rowContext = new RowNumberBindingContext(this.iteratorNameArray[i], indices[i] + 1);
            }
            clone.getBindingContext().getRowNumberBindingContexts().add(rowContext);
            clone.getBindingContext().getRowNumberBindingContexts().addAll(owningTable.getBindingContext().getRowNumberBindingContexts());
        }
    }

    private String getMergedIdBasedOnIterators(int[] indices) {
        StringBuilder idBuilder = new StringBuilder();
        for (int index : indices) {
            idBuilder.append('[');
            idBuilder.append(index);
            idBuilder.append(']');
        }
        return idBuilder.toString();
    }

    private String[] buildIteratorNameArray(List<IRepeatableIteratorInfo> currentIterators) {
        String[] iterators = new String[currentIterators.size()];
        for (int i = 0; i < iterators.length; ++i) {
            iterators[i] = currentIterators.get(i).getName();
        }
        return iterators;
    }
}

