/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests.base;

import java.io.IOException;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsRequest;

public abstract class CoinPaymentsPostRequest<T>
extends CoinPaymentsRequest<T> {
    private static final Logger log = Logger.getLogger(CoinPaymentsPostRequest.class);

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public T execute() throws ClientProtocolException, IOException {
        HttpPost post = new HttpPost("https://www.coinpayments.net/api.php" + this.getUrl());
        post.addHeader("Connection", "close");
        post.addHeader("Accept", "*/*");
        post.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        post.addHeader("Cookie2", "$Version=1");
        post.addHeader("Accept-Language", "en-US");
        String payload = this.getPayload();
        log.info((Object)("Base Payload: " + payload));
        payload = payload + "&version=1&key=" + this.api.getPublicKey() + "&format=json";
        String hmac = HmacUtils.hmacSha512Hex((String)this.api.getPrivateKey(), (String)payload);
        log.info((Object)("HMAC: " + hmac));
        post.addHeader("HMAC", hmac);
        log.info((Object)("Final Payload: " + payload));
        post.setEntity((HttpEntity)new StringEntity(payload));
        CloseableHttpResponse response = this.api.getClient().execute((HttpUriRequest)post);
        this.api.setLastResponse((HttpResponse)response);
        int resultCode = response.getStatusLine().getStatusCode();
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        post.releaseConnection();
        return this.parseResult(resultCode, content);
    }

    public boolean isSigned() {
        return true;
    }

    public String toString() {
        return "CoinPaymentsPostRequest()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsPostRequest)) {
            return false;
        }
        CoinPaymentsPostRequest other = (CoinPaymentsPostRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsPostRequest;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

