/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.model.UpdateTagProfileResponse;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsUpdateTagProfileRequest
extends CoinPaymentsPostRequest<ResponseWrapper<List<UpdateTagProfileResponse>>> {
    @NonNull
    private String tagId;
    private String name;
    private String email;
    private String url;
    private String image;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        String p = !this.name.isEmpty() ? "&name=" + this.name : "";
        p = !this.email.isEmpty() ? "&email=" + this.email : p;
        p = !this.url.isEmpty() ? "&url=" + this.url : p;
        p = !this.image.isEmpty() ? "&image=" + this.image : p;
        return "cmd=update_pbn_tag&tagid=" + this.tagId + p;
    }

    @Override
    public ResponseWrapper<List<UpdateTagProfileResponse>> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<List<UpdateTagProfileResponse>>>(){});
        return wrapper;
    }

    private static String $default$name() {
        return "";
    }

    private static String $default$email() {
        return "";
    }

    private static String $default$url() {
        return "";
    }

    private static String $default$image() {
        return "";
    }

    public static CoinPaymentsUpdateTagProfileRequestBuilder builder() {
        return new CoinPaymentsUpdateTagProfileRequestBuilder();
    }

    public CoinPaymentsUpdateTagProfileRequest(@NonNull String tagId) {
        if (tagId == null) {
            throw new NullPointerException("tagId");
        }
        this.tagId = tagId;
    }

    public CoinPaymentsUpdateTagProfileRequest(@NonNull String tagId, String name, String email, String url, String image) {
        if (tagId == null) {
            throw new NullPointerException("tagId");
        }
        this.tagId = tagId;
        this.name = name;
        this.email = email;
        this.url = url;
        this.image = image;
    }

    @NonNull
    public String getTagId() {
        return this.tagId;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getImage() {
        return this.image;
    }

    public void setTagId(@NonNull String tagId) {
        if (tagId == null) {
            throw new NullPointerException("tagId");
        }
        this.tagId = tagId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsUpdateTagProfileRequest)) {
            return false;
        }
        CoinPaymentsUpdateTagProfileRequest other = (CoinPaymentsUpdateTagProfileRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsUpdateTagProfileRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsUpdateTagProfileRequest(tagId=" + this.getTagId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", url=" + this.getUrl() + ", image=" + this.getImage() + ")";
    }

    public static class CoinPaymentsUpdateTagProfileRequestBuilder {
        private String tagId;
        private boolean name$set;
        private String name;
        private boolean email$set;
        private String email;
        private boolean url$set;
        private String url;
        private boolean image$set;
        private String image;

        CoinPaymentsUpdateTagProfileRequestBuilder() {
        }

        public CoinPaymentsUpdateTagProfileRequestBuilder tagId(String tagId) {
            this.tagId = tagId;
            return this;
        }

        public CoinPaymentsUpdateTagProfileRequestBuilder name(String name) {
            this.name = name;
            this.name$set = true;
            return this;
        }

        public CoinPaymentsUpdateTagProfileRequestBuilder email(String email) {
            this.email = email;
            this.email$set = true;
            return this;
        }

        public CoinPaymentsUpdateTagProfileRequestBuilder url(String url) {
            this.url = url;
            this.url$set = true;
            return this;
        }

        public CoinPaymentsUpdateTagProfileRequestBuilder image(String image) {
            this.image = image;
            this.image$set = true;
            return this;
        }

        public CoinPaymentsUpdateTagProfileRequest build() {
            String name = this.name;
            if (!this.name$set) {
                name = CoinPaymentsUpdateTagProfileRequest.$default$name();
            }
            String email = this.email;
            if (!this.email$set) {
                email = CoinPaymentsUpdateTagProfileRequest.$default$email();
            }
            String url = this.url;
            if (!this.url$set) {
                url = CoinPaymentsUpdateTagProfileRequest.$default$url();
            }
            String image = this.image;
            if (!this.image$set) {
                image = CoinPaymentsUpdateTagProfileRequest.$default$image();
            }
            return new CoinPaymentsUpdateTagProfileRequest(this.tagId, name, email, url, image);
        }

        public String toString() {
            return "CoinPaymentsUpdateTagProfileRequest.CoinPaymentsUpdateTagProfileRequestBuilder(tagId=" + this.tagId + ", name=" + this.name + ", email=" + this.email + ", url=" + this.url + ", image=" + this.image + ")";
        }
    }
}

