/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.brunocvcunha.coinpayments.model.RateResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsRatesRequest
extends CoinPaymentsPostRequest<ResponseWrapper<Map<String, RateResponse>>> {
    private boolean onlyAccepted = true;
    private boolean onlyShort = false;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=rates&accepted=" + (this.onlyAccepted ? "1" : "0") + "&short=" + (this.onlyShort ? "1" : "0");
    }

    @Override
    public ResponseWrapper<Map<String, RateResponse>> parseResult(int statusCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<Map<String, RateResponse>>>(){});
        return wrapper;
    }

    public static CoinPaymentsRatesRequestBuilder builder() {
        return new CoinPaymentsRatesRequestBuilder();
    }

    public CoinPaymentsRatesRequest() {
    }

    public CoinPaymentsRatesRequest(boolean onlyAccepted, boolean onlyShort) {
        this.onlyAccepted = onlyAccepted;
        this.onlyShort = onlyShort;
    }

    public boolean isOnlyAccepted() {
        return this.onlyAccepted;
    }

    public boolean isOnlyShort() {
        return this.onlyShort;
    }

    public void setOnlyAccepted(boolean onlyAccepted) {
        this.onlyAccepted = onlyAccepted;
    }

    public void setOnlyShort(boolean onlyShort) {
        this.onlyShort = onlyShort;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsRatesRequest)) {
            return false;
        }
        CoinPaymentsRatesRequest other = (CoinPaymentsRatesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnlyAccepted() != other.isOnlyAccepted()) {
            return false;
        }
        return this.isOnlyShort() == other.isOnlyShort();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsRatesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnlyAccepted() ? 79 : 97);
        result = result * 59 + (this.isOnlyShort() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsRatesRequest(onlyAccepted=" + this.isOnlyAccepted() + ", onlyShort=" + this.isOnlyShort() + ")";
    }

    public static class CoinPaymentsRatesRequestBuilder {
        private boolean onlyAccepted;
        private boolean onlyShort;

        CoinPaymentsRatesRequestBuilder() {
        }

        public CoinPaymentsRatesRequestBuilder onlyAccepted(boolean onlyAccepted) {
            this.onlyAccepted = onlyAccepted;
            return this;
        }

        public CoinPaymentsRatesRequestBuilder onlyShort(boolean onlyShort) {
            this.onlyShort = onlyShort;
            return this;
        }

        public CoinPaymentsRatesRequest build() {
            return new CoinPaymentsRatesRequest(this.onlyAccepted, this.onlyShort);
        }

        public String toString() {
            return "CoinPaymentsRatesRequest.CoinPaymentsRatesRequestBuilder(onlyAccepted=" + this.onlyAccepted + ", onlyShort=" + this.onlyShort + ")";
        }
    }
}

