/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.CreateTransferResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsCreateTransferRequest
extends CoinPaymentsPostRequest<ResponseWrapper<CreateTransferResponse>> {
    @NonNull
    private double amount;
    @NonNull
    private String currency;
    private String merchant;
    private String pbntag;
    private boolean autoConfirm;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        String p = !this.merchant.isEmpty() ? "&merchant=" + this.merchant : "&pbntag" + this.pbntag;
        return "cmd=create_transfer&amount=" + this.amount + p + "&currency=" + this.currency + "&auto_confirm=" + (this.autoConfirm ? 1 : 0);
    }

    @Override
    public ResponseWrapper<CreateTransferResponse> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<CreateTransferResponse>>(){});
        return wrapper;
    }

    private static String $default$merchant() {
        return "";
    }

    private static String $default$pbntag() {
        return "";
    }

    private static boolean $default$autoConfirm() {
        return true;
    }

    public static CoinPaymentsCreateTransferRequestBuilder builder() {
        return new CoinPaymentsCreateTransferRequestBuilder();
    }

    public CoinPaymentsCreateTransferRequest(@NonNull double amount, @NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.amount = amount;
        this.currency = currency;
    }

    public CoinPaymentsCreateTransferRequest(@NonNull double amount, @NonNull String currency, String merchant, String pbntag, boolean autoConfirm) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.amount = amount;
        this.currency = currency;
        this.merchant = merchant;
        this.pbntag = pbntag;
        this.autoConfirm = autoConfirm;
    }

    @NonNull
    public double getAmount() {
        return this.amount;
    }

    @NonNull
    public String getCurrency() {
        return this.currency;
    }

    public String getMerchant() {
        return this.merchant;
    }

    public String getPbntag() {
        return this.pbntag;
    }

    public boolean isAutoConfirm() {
        return this.autoConfirm;
    }

    public void setAmount(@NonNull double amount) {
        this.amount = amount;
    }

    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.currency = currency;
    }

    public void setMerchant(String merchant) {
        this.merchant = merchant;
    }

    public void setPbntag(String pbntag) {
        this.pbntag = pbntag;
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsCreateTransferRequest)) {
            return false;
        }
        CoinPaymentsCreateTransferRequest other = (CoinPaymentsCreateTransferRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$merchant = this.getMerchant();
        String other$merchant = other.getMerchant();
        if (this$merchant == null ? other$merchant != null : !this$merchant.equals(other$merchant)) {
            return false;
        }
        String this$pbntag = this.getPbntag();
        String other$pbntag = other.getPbntag();
        if (this$pbntag == null ? other$pbntag != null : !this$pbntag.equals(other$pbntag)) {
            return false;
        }
        return this.isAutoConfirm() == other.isAutoConfirm();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsCreateTransferRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $merchant = this.getMerchant();
        result = result * 59 + ($merchant == null ? 43 : $merchant.hashCode());
        String $pbntag = this.getPbntag();
        result = result * 59 + ($pbntag == null ? 43 : $pbntag.hashCode());
        result = result * 59 + (this.isAutoConfirm() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsCreateTransferRequest(amount=" + this.getAmount() + ", currency=" + this.getCurrency() + ", merchant=" + this.getMerchant() + ", pbntag=" + this.getPbntag() + ", autoConfirm=" + this.isAutoConfirm() + ")";
    }

    public static class CoinPaymentsCreateTransferRequestBuilder {
        private double amount;
        private String currency;
        private boolean merchant$set;
        private String merchant;
        private boolean pbntag$set;
        private String pbntag;
        private boolean autoConfirm$set;
        private boolean autoConfirm;

        CoinPaymentsCreateTransferRequestBuilder() {
        }

        public CoinPaymentsCreateTransferRequestBuilder amount(double amount) {
            this.amount = amount;
            return this;
        }

        public CoinPaymentsCreateTransferRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public CoinPaymentsCreateTransferRequestBuilder merchant(String merchant) {
            this.merchant = merchant;
            this.merchant$set = true;
            return this;
        }

        public CoinPaymentsCreateTransferRequestBuilder pbntag(String pbntag) {
            this.pbntag = pbntag;
            this.pbntag$set = true;
            return this;
        }

        public CoinPaymentsCreateTransferRequestBuilder autoConfirm(boolean autoConfirm) {
            this.autoConfirm = autoConfirm;
            this.autoConfirm$set = true;
            return this;
        }

        public CoinPaymentsCreateTransferRequest build() {
            String merchant = this.merchant;
            if (!this.merchant$set) {
                merchant = CoinPaymentsCreateTransferRequest.$default$merchant();
            }
            String pbntag = this.pbntag;
            if (!this.pbntag$set) {
                pbntag = CoinPaymentsCreateTransferRequest.$default$pbntag();
            }
            boolean autoConfirm = this.autoConfirm;
            if (!this.autoConfirm$set) {
                autoConfirm = CoinPaymentsCreateTransferRequest.$default$autoConfirm();
            }
            return new CoinPaymentsCreateTransferRequest(this.amount, this.currency, merchant, pbntag, autoConfirm);
        }

        public String toString() {
            return "CoinPaymentsCreateTransferRequest.CoinPaymentsCreateTransferRequestBuilder(amount=" + this.amount + ", currency=" + this.currency + ", merchant=" + this.merchant + ", pbntag=" + this.pbntag + ", autoConfirm=" + this.autoConfirm + ")";
        }
    }
}

