/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.NonNull;
import org.apache.log4j.Logger;
import org.brunocvcunha.coinpayments.model.CreateTransactionResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsCreateTransactionRequest
extends CoinPaymentsPostRequest<ResponseWrapper<CreateTransactionResponse>> {
    private static final Logger log = Logger.getLogger(CoinPaymentsCreateTransactionRequest.class);
    @NonNull
    private double amount;
    @NonNull
    private String currencyPrice;
    @NonNull
    private String currencyTransfer;
    private String address;
    private String buyerEmail;
    private String buyerName;
    private String itemName;
    private String itemCode;
    private String invoice;
    private String custom;
    private String callbackUrl;
    private long timeout;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=create_transaction&amount=" + this.amount + "" + "&currency1=" + this.currencyPrice + "&currency2=" + this.currencyTransfer + "&address=" + this.address + "&buyer_email=" + this.buyerEmail + "&buyer_name=" + this.buyerName + "&item_name=" + this.itemName + "&item_number=" + this.itemCode + "&invoice=" + this.invoice + "&custom=" + this.custom + "&ipn_url=" + this.callbackUrl + "&timeout=" + this.timeout;
    }

    @Override
    public ResponseWrapper<CreateTransactionResponse> parseResult(int statusCode, String content) {
        log.debug((Object)("parsing CreateTransactionResponse:  " + content + ", statusCode: " + statusCode));
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<CreateTransactionResponse>>(){});
        return wrapper;
    }

    private static String $default$address() {
        return "";
    }

    private static String $default$buyerEmail() {
        return "";
    }

    private static String $default$buyerName() {
        return "";
    }

    private static String $default$itemName() {
        return "";
    }

    private static String $default$itemCode() {
        return "";
    }

    private static String $default$invoice() {
        return "";
    }

    private static String $default$custom() {
        return "";
    }

    private static String $default$callbackUrl() {
        return "";
    }

    private static long $default$timeout() {
        return 7200L;
    }

    public static CoinPaymentsCreateTransactionRequestBuilder builder() {
        return new CoinPaymentsCreateTransactionRequestBuilder();
    }

    public CoinPaymentsCreateTransactionRequest(@NonNull double amount, @NonNull String currencyPrice, @NonNull String currencyTransfer) {
        if (currencyPrice == null) {
            throw new NullPointerException("currencyPrice");
        }
        if (currencyTransfer == null) {
            throw new NullPointerException("currencyTransfer");
        }
        this.amount = amount;
        this.currencyPrice = currencyPrice;
        this.currencyTransfer = currencyTransfer;
    }

    public CoinPaymentsCreateTransactionRequest(@NonNull double amount, @NonNull String currencyPrice, @NonNull String currencyTransfer, String address, String buyerEmail, String buyerName, String itemName, String itemCode, String invoice, String custom, String callbackUrl, long timeout) {
        if (currencyPrice == null) {
            throw new NullPointerException("currencyPrice");
        }
        if (currencyTransfer == null) {
            throw new NullPointerException("currencyTransfer");
        }
        this.amount = amount;
        this.currencyPrice = currencyPrice;
        this.currencyTransfer = currencyTransfer;
        this.address = address;
        this.buyerEmail = buyerEmail;
        this.buyerName = buyerName;
        this.itemName = itemName;
        this.itemCode = itemCode;
        this.invoice = invoice;
        this.custom = custom;
        this.callbackUrl = callbackUrl;
        this.timeout = timeout;
    }

    @NonNull
    public double getAmount() {
        return this.amount;
    }

    @NonNull
    public String getCurrencyPrice() {
        return this.currencyPrice;
    }

    @NonNull
    public String getCurrencyTransfer() {
        return this.currencyTransfer;
    }

    public String getAddress() {
        return this.address;
    }

    public String getBuyerEmail() {
        return this.buyerEmail;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public String getInvoice() {
        return this.invoice;
    }

    public String getCustom() {
        return this.custom;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setAmount(@NonNull double amount) {
        this.amount = amount;
    }

    public void setCurrencyPrice(@NonNull String currencyPrice) {
        if (currencyPrice == null) {
            throw new NullPointerException("currencyPrice");
        }
        this.currencyPrice = currencyPrice;
    }

    public void setCurrencyTransfer(@NonNull String currencyTransfer) {
        if (currencyTransfer == null) {
            throw new NullPointerException("currencyTransfer");
        }
        this.currencyTransfer = currencyTransfer;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public void setCustom(String custom) {
        this.custom = custom;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsCreateTransactionRequest)) {
            return false;
        }
        CoinPaymentsCreateTransactionRequest other = (CoinPaymentsCreateTransactionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        String this$currencyPrice = this.getCurrencyPrice();
        String other$currencyPrice = other.getCurrencyPrice();
        if (this$currencyPrice == null ? other$currencyPrice != null : !this$currencyPrice.equals(other$currencyPrice)) {
            return false;
        }
        String this$currencyTransfer = this.getCurrencyTransfer();
        String other$currencyTransfer = other.getCurrencyTransfer();
        if (this$currencyTransfer == null ? other$currencyTransfer != null : !this$currencyTransfer.equals(other$currencyTransfer)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$buyerEmail = this.getBuyerEmail();
        String other$buyerEmail = other.getBuyerEmail();
        if (this$buyerEmail == null ? other$buyerEmail != null : !this$buyerEmail.equals(other$buyerEmail)) {
            return false;
        }
        String this$buyerName = this.getBuyerName();
        String other$buyerName = other.getBuyerName();
        if (this$buyerName == null ? other$buyerName != null : !this$buyerName.equals(other$buyerName)) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        String this$itemCode = this.getItemCode();
        String other$itemCode = other.getItemCode();
        if (this$itemCode == null ? other$itemCode != null : !this$itemCode.equals(other$itemCode)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        String this$custom = this.getCustom();
        String other$custom = other.getCustom();
        if (this$custom == null ? other$custom != null : !this$custom.equals(other$custom)) {
            return false;
        }
        String this$callbackUrl = this.getCallbackUrl();
        String other$callbackUrl = other.getCallbackUrl();
        if (this$callbackUrl == null ? other$callbackUrl != null : !this$callbackUrl.equals(other$callbackUrl)) {
            return false;
        }
        return this.getTimeout() == other.getTimeout();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsCreateTransactionRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        String $currencyPrice = this.getCurrencyPrice();
        result = result * 59 + ($currencyPrice == null ? 43 : $currencyPrice.hashCode());
        String $currencyTransfer = this.getCurrencyTransfer();
        result = result * 59 + ($currencyTransfer == null ? 43 : $currencyTransfer.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $buyerEmail = this.getBuyerEmail();
        result = result * 59 + ($buyerEmail == null ? 43 : $buyerEmail.hashCode());
        String $buyerName = this.getBuyerName();
        result = result * 59 + ($buyerName == null ? 43 : $buyerName.hashCode());
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        String $itemCode = this.getItemCode();
        result = result * 59 + ($itemCode == null ? 43 : $itemCode.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        String $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : $custom.hashCode());
        String $callbackUrl = this.getCallbackUrl();
        result = result * 59 + ($callbackUrl == null ? 43 : $callbackUrl.hashCode());
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsCreateTransactionRequest(amount=" + this.getAmount() + ", currencyPrice=" + this.getCurrencyPrice() + ", currencyTransfer=" + this.getCurrencyTransfer() + ", address=" + this.getAddress() + ", buyerEmail=" + this.getBuyerEmail() + ", buyerName=" + this.getBuyerName() + ", itemName=" + this.getItemName() + ", itemCode=" + this.getItemCode() + ", invoice=" + this.getInvoice() + ", custom=" + this.getCustom() + ", callbackUrl=" + this.getCallbackUrl() + ", timeout=" + this.getTimeout() + ")";
    }

    public static class CoinPaymentsCreateTransactionRequestBuilder {
        private double amount;
        private String currencyPrice;
        private String currencyTransfer;
        private boolean address$set;
        private String address;
        private boolean buyerEmail$set;
        private String buyerEmail;
        private boolean buyerName$set;
        private String buyerName;
        private boolean itemName$set;
        private String itemName;
        private boolean itemCode$set;
        private String itemCode;
        private boolean invoice$set;
        private String invoice;
        private boolean custom$set;
        private String custom;
        private boolean callbackUrl$set;
        private String callbackUrl;
        private boolean timeout$set;
        private long timeout;

        CoinPaymentsCreateTransactionRequestBuilder() {
        }

        public CoinPaymentsCreateTransactionRequestBuilder amount(double amount) {
            this.amount = amount;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder currencyPrice(String currencyPrice) {
            this.currencyPrice = currencyPrice;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder currencyTransfer(String currencyTransfer) {
            this.currencyTransfer = currencyTransfer;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder address(String address) {
            this.address = address;
            this.address$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder buyerEmail(String buyerEmail) {
            this.buyerEmail = buyerEmail;
            this.buyerEmail$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder buyerName(String buyerName) {
            this.buyerName = buyerName;
            this.buyerName$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder itemName(String itemName) {
            this.itemName = itemName;
            this.itemName$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder itemCode(String itemCode) {
            this.itemCode = itemCode;
            this.itemCode$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder invoice(String invoice) {
            this.invoice = invoice;
            this.invoice$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder custom(String custom) {
            this.custom = custom;
            this.custom$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            this.callbackUrl$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequestBuilder timeout(long timeout) {
            this.timeout = timeout;
            this.timeout$set = true;
            return this;
        }

        public CoinPaymentsCreateTransactionRequest build() {
            String address = this.address;
            if (!this.address$set) {
                address = CoinPaymentsCreateTransactionRequest.$default$address();
            }
            String buyerEmail = this.buyerEmail;
            if (!this.buyerEmail$set) {
                buyerEmail = CoinPaymentsCreateTransactionRequest.$default$buyerEmail();
            }
            String buyerName = this.buyerName;
            if (!this.buyerName$set) {
                buyerName = CoinPaymentsCreateTransactionRequest.$default$buyerName();
            }
            String itemName = this.itemName;
            if (!this.itemName$set) {
                itemName = CoinPaymentsCreateTransactionRequest.$default$itemName();
            }
            String itemCode = this.itemCode;
            if (!this.itemCode$set) {
                itemCode = CoinPaymentsCreateTransactionRequest.$default$itemCode();
            }
            String invoice = this.invoice;
            if (!this.invoice$set) {
                invoice = CoinPaymentsCreateTransactionRequest.$default$invoice();
            }
            String custom = this.custom;
            if (!this.custom$set) {
                custom = CoinPaymentsCreateTransactionRequest.$default$custom();
            }
            String callbackUrl = this.callbackUrl;
            if (!this.callbackUrl$set) {
                callbackUrl = CoinPaymentsCreateTransactionRequest.$default$callbackUrl();
            }
            long timeout = this.timeout;
            if (!this.timeout$set) {
                timeout = CoinPaymentsCreateTransactionRequest.$default$timeout();
            }
            return new CoinPaymentsCreateTransactionRequest(this.amount, this.currencyPrice, this.currencyTransfer, address, buyerEmail, buyerName, itemName, itemCode, invoice, custom, callbackUrl, timeout);
        }

        public String toString() {
            return "CoinPaymentsCreateTransactionRequest.CoinPaymentsCreateTransactionRequestBuilder(amount=" + this.amount + ", currencyPrice=" + this.currencyPrice + ", currencyTransfer=" + this.currencyTransfer + ", address=" + this.address + ", buyerEmail=" + this.buyerEmail + ", buyerName=" + this.buyerName + ", itemName=" + this.itemName + ", itemCode=" + this.itemCode + ", invoice=" + this.invoice + ", custom=" + this.custom + ", callbackUrl=" + this.callbackUrl + ", timeout=" + this.timeout + ")";
        }
    }
}

