/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.ConversionLimitsResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsConversionLimitsRequest
extends CoinPaymentsPostRequest<ResponseWrapper<ConversionLimitsResponse>> {
    @NonNull
    private String from;
    @NonNull
    private String to;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=convert_limits&from=" + this.from + "&to=" + this.to;
    }

    @Override
    public ResponseWrapper<ConversionLimitsResponse> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<ConversionLimitsResponse>>(){});
        return wrapper;
    }

    public static CoinPaymentsConversionLimitsRequestBuilder builder() {
        return new CoinPaymentsConversionLimitsRequestBuilder();
    }

    public CoinPaymentsConversionLimitsRequest(@NonNull String from, @NonNull String to) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.from = from;
        this.to = to;
    }

    @NonNull
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    public void setFrom(@NonNull String from) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        this.from = from;
    }

    public void setTo(@NonNull String to) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.to = to;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsConversionLimitsRequest)) {
            return false;
        }
        CoinPaymentsConversionLimitsRequest other = (CoinPaymentsConversionLimitsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        return !(this$to == null ? other$to != null : !this$to.equals(other$to));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsConversionLimitsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsConversionLimitsRequest(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public static class CoinPaymentsConversionLimitsRequestBuilder {
        private String from;
        private String to;

        CoinPaymentsConversionLimitsRequestBuilder() {
        }

        public CoinPaymentsConversionLimitsRequestBuilder from(String from) {
            this.from = from;
            return this;
        }

        public CoinPaymentsConversionLimitsRequestBuilder to(String to) {
            this.to = to;
            return this;
        }

        public CoinPaymentsConversionLimitsRequest build() {
            return new CoinPaymentsConversionLimitsRequest(this.from, this.to);
        }

        public String toString() {
            return "CoinPaymentsConversionLimitsRequest.CoinPaymentsConversionLimitsRequestBuilder(from=" + this.from + ", to=" + this.to + ")";
        }
    }
}

