/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.security.DigipostPublicKey;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;

public final class Encrypter {
    public static final Encrypter FAIL_IF_TRYING_TO_ENCRYPT = new Encrypter();
    private final JceKeyTransRecipientInfoGenerator keyInfoGenerator;
    private static final JceCMSContentEncryptorBuilder encryptorBuilder = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider("BC");

    public static Encrypter using(DigipostPublicKey key) {
        return new Encrypter(new JceKeyTransRecipientInfoGenerator(key.publicKeyHash.getBytes(), key.publicKey));
    }

    public static Encrypter using(X509Certificate certificate) {
        try {
            return new Encrypter(new JceKeyTransRecipientInfoGenerator(certificate));
        }
        catch (CertificateEncodingException e) {
            throw new DigipostClientException(ErrorCode.FAILED_PREENCRYPTION, "Feil ved kryptering av innhold: " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
        }
    }

    private Encrypter(JceKeyTransRecipientInfoGenerator keyInfoGenerator) {
        this.keyInfoGenerator = keyInfoGenerator;
    }

    private Encrypter() {
        this.keyInfoGenerator = null;
    }

    public InputStream encrypt(InputStream content) {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray((InputStream)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", e);
        }
        return this.encrypt(bytes);
    }

    public InputStream encrypt(byte[] content) {
        if (this.keyInfoGenerator == null) {
            throw new DigipostClientException(ErrorCode.ENCRYPTION_KEY_NOT_FOUND, "Trying to preencrypt but have no encryption key.");
        }
        try {
            CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
            gen.addRecipientInfoGenerator((RecipientInfoGenerator)this.keyInfoGenerator);
            CMSEnvelopedData d = gen.generate((CMSTypedData)new CMSProcessableByteArray(content), encryptorBuilder.build());
            return new ByteArrayInputStream(d.getEncoded());
        }
        catch (Exception e) {
            if (e instanceof CMSException && ExceptionUtils.getRootCause((Throwable)e) instanceof InvalidKeyException) {
                throw new DigipostClientException(ErrorCode.FAILED_PREENCRYPTION, "Ugyldig krypteringsn\u00f8kkel. (" + InvalidKeyException.class.getName() + ") Er Java Cryptographic Extensions (JCE) Unlimited Strength Jurisdiction Policy Files installert? Dette kan lastes ned fra http://www.oracle.com/technetwork/java/javase/downloads/ under \"Additional Resources\". Plasser filene US_export_policy.jar og local_policy.jar i ${JAVA_HOME}/jre/lib/security (overskriv eksisterende).", e);
            }
            throw new DigipostClientException(ErrorCode.FAILED_PREENCRYPTION, "Feil ved kryptering av innhold: " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'", e);
        }
    }
}

