/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.archive;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.SenderId;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.SenderOrganization;
import no.digipost.api.client.representations.archive.ArchiveDocument;
import org.apache.commons.lang3.ObjectUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="archive", propOrder={"senderOrganization", "senderId", "name", "documents", "links"})
@XmlRootElement(name="archive")
public class Archive
extends Representation {
    @XmlElement(name="sender-organization", nillable=false)
    protected SenderOrganization senderOrganization;
    @XmlElement(name="sender-id", nillable=false)
    protected Long senderId;
    @XmlElement(nillable=false)
    protected String name;
    @XmlElement(nillable=false)
    protected List<ArchiveDocument> documents;

    public static ArchiveBuilder defaultArchive() {
        return new ArchiveBuilder();
    }

    public static ArchiveBuilder namedArchive(String archiveName) {
        return new ArchiveBuilder(archiveName);
    }

    public Archive() {
        super(new Link[0]);
        this.documents = new ArrayList<ArchiveDocument>();
    }

    public Archive(SenderOrganization senderOrganization, Long senderId, String name, List<Link> links, List<ArchiveDocument> documents) {
        super(new Link[0]);
        this.senderOrganization = senderOrganization;
        this.senderId = senderId;
        this.name = name;
        this.links = links;
        this.documents = documents;
    }

    public SenderOrganization getSenderOrganization() {
        return this.senderOrganization;
    }

    public void setSenderOrganization(SenderOrganization value) {
        this.senderOrganization = value;
    }

    public Long getSenderId() {
        return this.senderId;
    }

    public String getName() {
        return this.name;
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links;
    }

    protected void setLink(List<Link> links) {
        this.links = links;
    }

    public List<ArchiveDocument> getDocuments() {
        return this.documents;
    }

    public Optional<URI> getNextDocuments() {
        return Optional.ofNullable(this.getLinkByRelationName(Relation.NEXT_DOCUMENTS)).map(Link::getUri);
    }

    public static class ArchiveBuilder {
        private String name;
        private Long senderId;
        private SenderOrganization senderOrganization;
        private final List<ArchiveDocument> documents = new ArrayList<ArchiveDocument>();

        private ArchiveBuilder() {
        }

        private ArchiveBuilder(String name) {
            this.name = name;
        }

        public ArchiveBuilder senderId(SenderId senderId) {
            this.senderId = senderId.value();
            return this;
        }

        public ArchiveBuilder senderOrganization(SenderOrganization senderOrganization) {
            this.senderOrganization = senderOrganization;
            return this;
        }

        public ArchiveBuilder documents(ArchiveDocument ... documents) {
            return this.documents(Arrays.asList(documents));
        }

        public ArchiveBuilder documents(Iterable<ArchiveDocument> documents) {
            ((Iterable)ObjectUtils.defaultIfNull(documents, Collections.emptyList())).forEach(this.documents::add);
            return this;
        }

        public Archive build() {
            if (this.senderId != null && this.senderOrganization != null) {
                throw new IllegalStateException("You can't set both senderId *and* senderOrganization.");
            }
            return new Archive(this.senderOrganization, this.senderId, this.name, null, this.documents);
        }
    }
}

