/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import no.digipost.api.client.representations.Address;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Recipient
extends Representation {
    private String firstname;
    private String middlename;
    private String lastname;
    @XmlElement(name="digipost-address", required=true)
    private String digipostAddress;
    @XmlElement(name="mobile-number")
    protected String mobileNumber;
    @XmlElement(name="organisation-number")
    private String organisationNumber;
    @XmlElement(name="organisation-name")
    private String organisationName;
    @XmlElement(name="address")
    private final List<Address> addresses;

    public Recipient(String firstName, String middleName, String lastName, String digipostAddress, List<Address> addresses, Link ... links) {
        super(links);
        this.firstname = firstName;
        this.middlename = middleName;
        this.lastname = lastName;
        this.digipostAddress = digipostAddress;
        this.addresses = addresses;
    }

    Recipient() {
        this.addresses = new ArrayList<Address>();
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getMiddlename() {
        return this.middlename;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getDigipostAddress() {
        return this.digipostAddress;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public String getOrganisationNumber() {
        return this.organisationNumber;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public Link getSelfLink() {
        return this.getLinkByRelationName(Relation.SELF);
    }

    @XmlElement(name="link")
    protected List<Link> getLinks() {
        return this.links;
    }

    protected void setLinks(List<Link> links) {
        this.links = links;
    }

    public String toString() {
        return "Recipient{firstname='" + this.firstname + '\'' + ", middlename='" + this.middlename + '\'' + ", lastname='" + this.lastname + '\'' + ", digipostAddress='" + this.digipostAddress + '\'' + ", mobileNumber='" + this.mobileNumber + '\'' + ", organisationNumber='" + this.organisationNumber + '\'' + ", organisationName='" + this.organisationName + '\'' + ", addresses=" + this.addresses + ", links=" + this.links + '}';
    }
}

