/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.net.URI;
import java.net.URISyntaxException;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;

public class DigipostUri {
    private final URI uri;

    public DigipostUri(URI uri) {
        this.uri = uri;
    }

    public DigipostUri(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new DigipostClientException(ErrorCode.CLIENT_ERROR, e.getMessage());
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    public String getBaseUri() {
        String port = "";
        if (this.uri.getPort() != 80 && this.uri.getPort() != -1) {
            port = ":" + String.valueOf(this.uri.getPort());
        }
        return this.uri.getScheme() + "://" + this.uri.getHost() + port;
    }
}

