/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.http.request.interceptor;

import no.digipost.api.client.EventLogger;
import no.digipost.api.client.security.Digester;
import org.apache.http.HttpRequest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContentHashFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContentHashFilter.class);
    private final EventLogger eventLogger;
    private final Digester digester;
    private final String header;

    public RequestContentHashFilter(EventLogger eventLogger, Digester digester, String header) {
        this.eventLogger = (eventLogger != null ? eventLogger : EventLogger.NOOP_LOGGER).withDebugLogTo(LOG);
        this.digester = digester;
        this.header = header;
    }

    public RequestContentHashFilter(Digester digester, String header) {
        this(EventLogger.NOOP_LOGGER, digester, header);
    }

    public void settContentHashHeader(byte[] data, HttpRequest httpRequest) {
        byte[] result = this.digester.createDigest(data);
        String hash = new String(Base64.encode((byte[])result));
        httpRequest.setHeader(this.header, hash);
        this.eventLogger.log(RequestContentHashFilter.class.getSimpleName() + " satt headeren " + this.header + "=" + hash);
    }
}

