/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.delivery;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import no.digipost.api.client.archive.ArchiveApi;
import no.digipost.api.client.internal.delivery.ArchiveDeliverer;
import no.digipost.api.client.internal.delivery.DocumentContent;
import no.digipost.api.client.representations.archive.Archive;
import no.digipost.api.client.representations.archive.ArchiveDocument;

public class PerformingArchivingDocuments
implements ArchiveApi.ArchivingDocuments {
    private final Archive archive;
    private final ArchiveDeliverer archiveDeliverer;
    private final Map<UUID, DocumentContent> documents = new LinkedHashMap<UUID, DocumentContent>();

    public PerformingArchivingDocuments(Archive archive, ArchiveDeliverer archiveDeliverer) {
        this.archive = archive;
        this.archiveDeliverer = archiveDeliverer;
    }

    @Override
    public ArchiveApi.ArchivingDocuments addFile(ArchiveDocument document, InputStream content) {
        this.documents.put(document.uuid, DocumentContent.CreateBothStreamContent(content));
        return this;
    }

    @Override
    public Archive send() {
        return this.archiveDeliverer.sendMultipartMessage(this.archive, this.documents);
    }
}

