/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.delivery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.delivery.MessageDeliveryApi;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.internal.ExceptionUtils;
import no.digipost.api.client.internal.delivery.DocumentContent;
import no.digipost.api.client.internal.delivery.DocumentsPreparer;
import no.digipost.api.client.internal.delivery.PrintOnlyMessage;
import no.digipost.api.client.internal.delivery.WithPrintFallback;
import no.digipost.api.client.internal.http.response.HttpResponseUtils;
import no.digipost.api.client.representations.AddDataLink;
import no.digipost.api.client.representations.AdditionalData;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.EncryptionCertificate;
import no.digipost.api.client.representations.EncryptionKey;
import no.digipost.api.client.representations.Identification;
import no.digipost.api.client.representations.IdentificationResultCode;
import no.digipost.api.client.representations.IdentificationResultWithEncryptionKey;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;
import no.digipost.api.client.security.DigipostPublicKey;
import no.digipost.api.client.security.Encrypter;
import no.digipost.api.client.util.JAXBContextUtils;
import no.digipost.print.validate.PdfValidator;
import no.digipost.sanitizing.HtmlValidator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeliverer {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDeliverer.class);
    private final Clock clock;
    private final DocumentsPreparer documentsPreparer;
    private final DigipostClientConfig config;
    private final MessageDeliveryApi apiService;
    private final EventLogger eventLogger;
    private Instant printKeyCachedTime = Instant.MIN;
    private X509Certificate cachedPrintCertificate;

    public MessageDeliverer(DigipostClientConfig config, MessageDeliveryApi apiService) {
        this(config, apiService, new DocumentsPreparer(new PdfValidator(), new HtmlValidator()));
    }

    public MessageDeliverer(DigipostClientConfig config, MessageDeliveryApi apiService, DocumentsPreparer documentsPreparer) {
        this.eventLogger = config.eventLogger.withDebugLogTo(LOG);
        this.config = config;
        this.apiService = apiService;
        this.documentsPreparer = documentsPreparer;
        this.clock = config.clock;
    }

    public OngoingDelivery.WithPrintFallback createMessage(Message message) {
        return new WithPrintFallback(message, this);
    }

    public OngoingDelivery.ForPrintOnly createPrintOnlyMessage(Message printMessage) {
        return new PrintOnlyMessage(printMessage, this);
    }

    public MessageDelivery sendMultipartMessage(Message message, Map<UUID, DocumentContent> documentsAndContent) {
        MessageDelivery messageDelivery;
        block12: {
            EncrypterAndDocsWithInputstream encryptionAndInputStream = this.createEncrypterIfNecessaryAndMapContentToInputstream(message, documentsAndContent);
            Map<Document, InputStream> documentInputStream = encryptionAndInputStream.documentsAndInputstream;
            Message singleChannelMessage = encryptionAndInputStream.getSingleChannelMessage();
            Map<Document, InputStream> preparedDocuments = this.documentsPreparer.prepare(documentInputStream, singleChannelMessage, encryptionAndInputStream.encrypter, () -> this.apiService.getSenderInformation(message).getPdfValidationSettings(), this.config);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, singleChannelMessage, (OutputStream)bao);
            ByteArrayBody attachment = new ByteArrayBody(bao.toByteArray(), ContentType.create((String)"application/vnd.digipost-v7+xml", (Charset)StandardCharsets.UTF_8), "message");
            MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.STRICT).setMimeSubtype("vnd.digipost-v7+xml").addPart(FormBodyPartBuilder.create((String)"message", (ContentBody)attachment).addField("Content-Disposition", "attachment; filename=\"message\"").build());
            for (Map.Entry<Document, InputStream> documentAndContent : preparedDocuments.entrySet()) {
                Document document = documentAndContent.getKey();
                InputStream content = documentAndContent.getValue();
                byte[] bytes = IOUtils.toByteArray((InputStream)content);
                multipartEntity = multipartEntity.addPart(FormBodyPartBuilder.create((String)"application", (ContentBody)new ByteArrayBody(bytes, ContentType.create((String)("application/" + (String)StringUtils.defaultIfBlank((CharSequence)document.getDigipostFileType(), (CharSequence)"octet-stream"))), document.uuid.toString())).addField("Content-Disposition", "attachment; filename=\"" + document.uuid.toString() + "\"").build());
            }
            this.eventLogger.log("*** STARTER INTERAKSJON MED API: SENDER MELDING MED ID " + singleChannelMessage.messageId + " ***");
            CloseableHttpResponse response = this.apiService.sendMultipartMessage(multipartEntity.build());
            try {
                HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                this.eventLogger.log("Brevet ble sendt. Status: [" + response + "]");
                messageDelivery = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), MessageDelivery.class);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage());
                    }
                }
                catch (Exception e) {
                    throw DigipostClientException.from(e);
                }
            }
            response.close();
        }
        return messageDelivery;
    }

    public void addData(AddDataLink addDataLink, AdditionalData data) {
        this.eventLogger.log("*** STARTER INTERAKSJON MED API: LEGGER TIL DATA P\u00c5 DOKUMENT ***");
        try (CloseableHttpResponse response = this.apiService.addData(addDataLink, data);){
            HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
            this.eventLogger.log("Data ble lagt til dokument. Status: [" + response.toString() + "]");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public InputStream fetchKeyAndEncrypt(Document document, InputStream content) {
        InputStream inputStream;
        block8: {
            this.checkThatMessageCanBePreEncrypted(document);
            CloseableHttpResponse encryptionKeyResponse = this.apiService.getEncryptionKey(document.getEncryptionKeyLink().getUri());
            try {
                HttpResponseUtils.checkResponse((HttpResponse)encryptionKeyResponse, this.eventLogger);
                EncryptionKey key = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, encryptionKeyResponse.getEntity().getContent(), EncryptionKey.class);
                inputStream = Encrypter.using(new DigipostPublicKey(key)).encrypt(content);
                if (encryptionKeyResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (encryptionKeyResponse != null) {
                        try {
                            encryptionKeyResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionUtils.asUnchecked(e);
                }
            }
            encryptionKeyResponse.close();
        }
        return inputStream;
    }

    public IdentificationResultWithEncryptionKey identifyAndGetEncryptionKey(Identification identification) {
        IdentificationResultWithEncryptionKey identificationResultWithEncryptionKey;
        block11: {
            CloseableHttpResponse response = this.apiService.identifyAndGetEncryptionKey(identification);
            try {
                HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                IdentificationResultWithEncryptionKey result = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), IdentificationResultWithEncryptionKey.class);
                if (result.getResultCode() == IdentificationResultCode.DIGIPOST) {
                    if (result.getEncryptionKey() == null) {
                        throw new DigipostClientException(ErrorCode.SERVER_ERROR, "Server identifisert mottaker som Digipost-bruker, men sendte ikke med krypteringsn\u00f8kkel. Indikerer en feil hos Digipost.");
                    }
                    this.eventLogger.log("Mottaker er Digipost-bruker. Hentet krypteringsn\u00f8kkel.");
                } else {
                    this.eventLogger.log("Mottaker er ikke Digipost-bruker.");
                }
                identificationResultWithEncryptionKey = result;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionUtils.asUnchecked(e);
                }
            }
            response.close();
        }
        return identificationResultWithEncryptionKey;
    }

    public X509Certificate getEncryptionCertificateForPrint() {
        Instant now = this.clock.instant();
        if (Duration.ZERO.equals(this.config.printKeyCacheTimeToLive) || Duration.between(this.printKeyCachedTime, now).compareTo(this.config.printKeyCacheTimeToLive) > 0) {
            X509Certificate x509Certificate;
            block9: {
                this.eventLogger.log("*** STARTER INTERAKSJON MED API: HENT KRYPTERINGSN\u00d8KKEL FOR PRINT ***");
                CloseableHttpResponse response = this.apiService.getEncryptionCertificateForPrint();
                try {
                    HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                    EncryptionCertificate encryptionCertificate = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), EncryptionCertificate.class);
                    this.cachedPrintCertificate = encryptionCertificate.getX509Certificate();
                    this.printKeyCachedTime = now;
                    x509Certificate = this.cachedPrintCertificate;
                    if (response == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                response.close();
            }
            return x509Certificate;
        }
        this.eventLogger.log("Bruker cachet krypteringsn\u00f8kkel for print");
        return this.cachedPrintCertificate;
    }

    private void checkThatMessageCanBePreEncrypted(Document document) {
        Link encryptionKeyLink = document.getEncryptionKeyLink();
        if (encryptionKeyLink == null) {
            String errorMessage = "Document med id [" + document.uuid + "] kan ikke prekrypteres.";
            this.eventLogger.log(errorMessage);
            throw new DigipostClientException(ErrorCode.CANNOT_PREENCRYPT, errorMessage);
        }
    }

    private EncrypterAndDocsWithInputstream createEncrypterIfNecessaryAndMapContentToInputstream(Message message, Map<UUID, DocumentContent> documentsAndContent) {
        Message singleChannelMessage;
        LinkedHashMap<Document, InputStream> documentsAndInputstream = new LinkedHashMap<Document, InputStream>();
        Encrypter encrypter = Encrypter.FAIL_IF_TRYING_TO_ENCRYPT;
        if (message.isDirectPrint()) {
            singleChannelMessage = MessageDeliverer.setMapAndMessageToPrint(message, documentsAndContent, documentsAndInputstream);
            if (singleChannelMessage.hasAnyDocumentRequiringEncryption()) {
                this.eventLogger.log("Direkte print. Bruker krypteringsn\u00f8kkel for print.");
                encrypter = Encrypter.using(this.getEncryptionCertificateForPrint());
            }
        } else if (!message.recipient.hasPrintDetails() && !message.hasAnyDocumentRequiringEncryption()) {
            singleChannelMessage = MessageDeliverer.setMapAndMessageToDigipost(message, documentsAndContent, documentsAndInputstream);
        } else {
            IdentificationResultWithEncryptionKey result = this.identifyAndGetEncryptionKey(message.recipient.toIdentification());
            if (result.getResultCode() == IdentificationResultCode.DIGIPOST) {
                singleChannelMessage = MessageDeliverer.setMapAndMessageToDigipost(message, documentsAndContent, documentsAndInputstream);
                if (singleChannelMessage.hasAnyDocumentRequiringEncryption()) {
                    this.eventLogger.log("Mottaker er Digipost-bruker. Bruker brukers krypteringsn\u00f8kkel.");
                    encrypter = Encrypter.using(new DigipostPublicKey(result.getEncryptionKey()));
                }
            } else if (message.recipient.hasPrintDetails()) {
                singleChannelMessage = MessageDeliverer.setMapAndMessageToPrint(message, documentsAndContent, documentsAndInputstream);
                if (singleChannelMessage.hasAnyDocumentRequiringEncryption()) {
                    this.eventLogger.log("Mottaker er ikke Digipost-bruker. Bruker krypteringsn\u00f8kkel for print.");
                    encrypter = Encrypter.using(this.getEncryptionCertificateForPrint());
                }
            } else {
                throw new DigipostClientException(ErrorCode.UNKNOWN_RECIPIENT, "Mottaker er ikke Digipost-bruker og forsendelse mangler print-fallback.");
            }
        }
        return new EncrypterAndDocsWithInputstream(encrypter, documentsAndInputstream, singleChannelMessage);
    }

    static Message setMapAndMessageToDigipost(Message messageToCopy, Map<UUID, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputStream) {
        Message singleChannelMessage = Message.copyMessageWithOnlyDigipostDetails(messageToCopy);
        MessageDeliverer.setDigipostContentToUUID(documentsAndContent, documentsAndInputStream, singleChannelMessage.getAllDocuments());
        return singleChannelMessage;
    }

    static Message setMapAndMessageToPrint(Message messageToCopy, Map<UUID, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputStream) {
        Message singleChannelMessage = Message.copyMessageWithOnlyPrintDetails(messageToCopy);
        MessageDeliverer.setPrintContentToUUID(documentsAndContent, documentsAndInputStream, singleChannelMessage.getAllDocuments());
        return singleChannelMessage;
    }

    static void setDigipostContentToUUID(Map<UUID, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputstream, Stream<Document> allDocuments) {
        allDocuments.forEach(doc -> documentsAndInputstream.put((Document)doc, ((DocumentContent)documentsAndContent.get(doc.uuid)).getDigipostContent()));
    }

    static void setPrintContentToUUID(Map<UUID, DocumentContent> documentsAndContent, Map<Document, InputStream> documentsAndInputstream, Stream<Document> allDocuments) {
        allDocuments.forEach(doc -> documentsAndInputstream.put((Document)doc, ((DocumentContent)documentsAndContent.get(doc.uuid)).getPrintContent()));
    }

    private static class EncrypterAndDocsWithInputstream {
        public final Encrypter encrypter;
        public final Map<Document, InputStream> documentsAndInputstream;
        private final Message singleChannelMessage;

        public EncrypterAndDocsWithInputstream(Encrypter encrypter, Map<Document, InputStream> documentsAndInputstream, Message singleChannelMessage) {
            this.encrypter = encrypter;
            this.documentsAndInputstream = documentsAndInputstream;
            this.singleChannelMessage = singleChannelMessage;
        }

        public Message getSingleChannelMessage() {
            return this.singleChannelMessage;
        }
    }
}

