/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import nl._42.boot.docker.postgres.DockerPostgresProperties;
import nl._42.boot.docker.utils.DockerOutputResult;
import nl._42.boot.docker.utils.ProcessRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DockerFiniteProcessRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerFiniteProcessRunner.class);
    private final ProcessRunner processRunner;
    private final String command;
    private final String stdOutFilename;
    private final String stdErrFilename;

    public DockerFiniteProcessRunner(String command, DockerPostgresProperties properties) {
        this.command = command;
        this.stdOutFilename = properties.getStdOutFilename();
        this.stdErrFilename = properties.getStdErrFilename();
        this.processRunner = new ProcessRunner(command, properties);
    }

    public DockerOutputResult execute() throws IOException {
        int exitValue = this.processRunner.execute();
        if (exitValue != 0) {
            LOGGER.error("| Docker command: " + this.command + " failed to execute");
            throw new ExceptionInInitializerError("Docker command: " + this.command + " failed to execute");
        }
        return new DockerOutputResult(DockerFiniteProcessRunner.readFile(this.stdOutFilename, Charset.defaultCharset()), DockerFiniteProcessRunner.readFile(this.stdErrFilename, Charset.defaultCharset()), exitValue);
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

