/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.postgres;

import java.io.IOException;
import nl._42.boot.docker.postgres.AbstractDockerAvailableCheck;
import nl._42.boot.docker.postgres.DockerPostgresBootSequence;
import nl._42.boot.docker.postgres.DockerPostgresProperties;
import nl._42.boot.docker.postgres.ExpectedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerImageAvailableCheck
extends AbstractDockerAvailableCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerPostgresBootSequence.class);
    private static final String COMMAND = "docker image ls";
    private final String imageName;
    private final String imageVersion;

    public DockerImageAvailableCheck(DockerPostgresProperties properties) {
        super(COMMAND, properties);
        this.imageName = properties.getImageName();
        this.imageVersion = properties.getImageVersion();
    }

    public boolean hasImage() throws IOException {
        if (this.hasValues(new ExpectedValue(0, this.imageName), new ExpectedValue(1, this.imageVersion))) {
            LOGGER.info("| Image [" + this.imageName + ":" + this.imageVersion + "] already downloaded");
            return true;
        }
        LOGGER.info("| Image [" + this.imageName + ":" + this.imageVersion + "] not yet downloaded");
        return false;
    }
}

