/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.postgres;

import java.io.IOException;
import nl._42.boot.docker.postgres.AbstractDockerAvailableCheck;
import nl._42.boot.docker.postgres.DockerPostgresBootSequence;
import nl._42.boot.docker.postgres.DockerPostgresProperties;
import nl._42.boot.docker.utils.DockerOutputResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerAvailableCheck
extends AbstractDockerAvailableCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerPostgresBootSequence.class);
    private static final String COMMAND = "docker --version";

    public DockerAvailableCheck(DockerPostgresProperties properties) {
        super(COMMAND, properties);
    }

    public void tryDocker() throws IOException {
        try {
            DockerOutputResult result = this.execute();
            LOGGER.info("| > " + result.getStdOut().trim());
        }
        catch (ExceptionInInitializerError ex) {
            LOGGER.error("| Docker not available. Make sure to install Docker on your system.");
            throw new ExceptionInInitializerError("Docker not available. Make sure to install Docker on your system.");
        }
    }
}

