/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.template;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.ArgProcessorBase;
import com.google.gwt.dev.util.arg.ArgHandlerLogLevel;
import com.google.gwt.dev.util.arg.OptionLogLevel;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerString;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import xapi.dev.source.SourceBuilder;
import xapi.dev.template.CompilationFailed;
import xapi.dev.template.TemplateClassGenerator;

public class TemplateGeneratorOptions
extends ArgProcessorBase
implements OptionLogLevel {
    private final List<String> templates = new ArrayList<String>();
    private final List<String> extraData = new ArrayList<String>();
    private final PayloadTypeArg payloadArg;
    private final Map<String, SourceBuilder<?>> context;
    private TreeLogger.Type logLevel = TreeLogger.Type.INFO;
    private String outputLocation = "src/main/java";

    public TemplateGeneratorOptions() {
        this.payloadArg = new PayloadTypeArg();
        this.context = new HashMap();
        this.registerHandler((ArgHandler)new TemplateLocationArg(this.templates));
        this.registerHandler((ArgHandler)this.payloadArg);
        this.registerHandler((ArgHandler)new ExtraOptionsArg(this.extraData));
        this.registerHandler((ArgHandler)new TemplateOutputLocationArg(this));
        this.registerHandler((ArgHandler)new ArgHandlerLogLevel((OptionLogLevel)this));
    }

    protected String getName() {
        return "TemplateToJava";
    }

    public List<String> getTemplates() {
        return this.templates;
    }

    public SourceBuilder<?> getContext(TreeLogger logger, String forTemplate) {
        SourceBuilder ctx = this.context.get(forTemplate);
        if (ctx == null) {
            ctx = new SourceBuilder();
            Object payload = this.payloadArg.getPayload(logger, this);
            ctx.setPayload(payload);
        }
        return ctx;
    }

    public List<String> getExtraData() {
        return this.extraData;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public TreeLogger.Type getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(TreeLogger.Type logLevel) {
        this.logLevel = logLevel;
    }

    public static class PayloadTypeArg
    extends ArgHandlerString {
        private String payloadClass = "java.lang.Object";
        private Object payload;

        public boolean setString(String str) {
            this.payloadClass = str;
            return true;
        }

        public String getPurpose() {
            return "Fully qualified classname of payload used in the SourceBuilder object.\n\t  This class must be static with a zero-arg public constructor.\n\t  For complex projects using multiple generators, you are recommended to use interfaces that will be injected via X_Inject.singleton()";
        }

        public String getTag() {
            return "-payload";
        }

        public String[] getTagArgs() {
            return new String[]{"com.template.payload.ClassName"};
        }

        public Object getPayload(TreeLogger logger, TemplateGeneratorOptions options) {
            if (this.payload == null) {
                try {
                    this.payload = Class.forName(this.payloadClass).newInstance();
                }
                catch (Exception e) {
                    throw new CompilationFailed("Unable to instantiate payload type.", e);
                }
                if (this.payload instanceof TemplateClassGenerator) {
                    ((TemplateClassGenerator)this.payload).initialize(logger, options);
                }
            }
            return this.payload;
        }
    }

    public static class ExtraOptionsArg
    extends ArgHandlerString {
        private final List<String> extras;

        public ExtraOptionsArg(List<String> extras) {
            this.extras = extras;
        }

        public boolean setString(String str) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                this.extras.add(st.nextToken().trim());
            }
            return true;
        }

        public String getPurpose() {
            return "Extra data you wish to make available to your context's payload object.";
        }

        public String getTag() {
            return "-extra";
        }

        public String[] getTagArgs() {
            return new String[]{"\"String Data Of Your Choosing\""};
        }
    }

    public static class TemplateLocationArg
    extends ArgHandlerString {
        private final List<String> templates;

        public TemplateLocationArg(List<String> templates) {
            this.templates = templates;
        }

        public boolean setString(String str) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                this.templates.add(st.nextToken().trim());
            }
            return true;
        }

        public String getPurpose() {
            return "Locations of template to generate from classpath resources, using / as a delimiter.";
        }

        public String getTag() {
            return "-template";
        }

        public String[] getTagArgs() {
            return new String[]{"package/location/TemplateFile.x"};
        }

        public boolean isRequired() {
            return true;
        }
    }

    public static class TemplateOutputLocationArg
    extends ArgHandlerString {
        private final TemplateGeneratorOptions opts;

        public TemplateOutputLocationArg(TemplateGeneratorOptions opts) {
            this.opts = opts;
        }

        public boolean setString(String str) {
            this.opts.outputLocation = str.endsWith(File.separator) ? str : str + File.separator;
            return true;
        }

        public String getPurpose() {
            return "Location to output generated files.  Default location is ${launch_directory}/src/main/java.";
        }

        public String getTag() {
            return "-output";
        }

        public String[] getTagArgs() {
            return new String[]{"${workspace_loc:some-project}/src/main/java"};
        }
    }
}

