/*
 * OfficeFloor - http://www.officefloor.net
 * Copyright (C) 2005-2013 Daniel Sagenschneider
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.officefloor.tutorial.authenticationhttpserver;

import java.io.Serializable;

import net.officefloor.plugin.web.http.application.HttpParameters;
import net.officefloor.plugin.web.http.security.HttpCredentials;
import net.officefloor.plugin.web.http.security.scheme.HttpCredentialsImpl;
import net.officefloor.plugin.work.clazz.FlowInterface;
import lombok.Data;

/**
 * Logic for <code>login</code> page.
 * 
 * @author Daniel Sagenschneider
 */
// START SNIPPET: tutorial
public class LoginLogic {

	@Data
	@HttpParameters
	public static class Form implements Serializable {

		private String username;

		private String password;
	}

	@FlowInterface
	public static interface Flows {

		void authenticate(HttpCredentials credentials);
	}

	public void login(Form form, Flows flows) {
		flows.authenticate(new HttpCredentialsImpl(form.getUsername(), form
				.getPassword()));
	}

}
// END SNIPPET: tutorial