/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.tutorial.teamhttpserver;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.officefloor.plugin.managedfunction.clazz.FlowInterface;
import net.officefloor.plugin.section.clazz.NextFunction;
import net.officefloor.plugin.section.clazz.Parameter;
import net.officefloor.tutorial.teamhttpserver.EncryptLetter;
import net.officefloor.tutorial.teamhttpserver.LetterEncryption;
import net.officefloor.web.HttpSessionStateful;

@HttpSessionStateful
public class Template
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Character, LetterEncryption> cache = new HashMap<Character, LetterEncryption>();
    private LetterEncryption displayCode;
    private String cacheThreadName;
    private String databaseThreadName;

    public LetterEncryption getTemplate() {
        return this.displayCode == null ? new LetterEncryption(' ', ' ') : this.displayCode;
    }

    public Template getThreadNames() {
        return this;
    }

    public String getCacheThreadName() {
        return this.cacheThreadName;
    }

    public String getDatabaseThreadName() {
        return this.databaseThreadName;
    }

    @NextFunction(value="setDisplayCode")
    public LetterEncryption encrypt(EncryptLetter request, PageFlows flows) {
        this.cacheThreadName = Thread.currentThread().getName();
        this.databaseThreadName = "[cached]";
        char letter = request.getLetter();
        LetterEncryption code = this.cache.get(Character.valueOf(letter));
        if (code != null) {
            return code;
        }
        flows.retrieveFromDatabase(letter);
        return null;
    }

    public void setDisplayCode(@Parameter LetterEncryption encryption) {
        this.displayCode = encryption;
    }

    @NextFunction(value="setDisplayCode")
    public LetterEncryption retrieveFromDatabase(@Parameter char letter, Connection connection) throws SQLException {
        this.databaseThreadName = Thread.currentThread().getName();
        PreparedStatement statement = connection.prepareStatement("SELECT CODE FROM LETTER_CODE WHERE LETTER = ?");
        statement.setString(1, String.valueOf(letter));
        ResultSet resultSet = statement.executeQuery();
        resultSet.next();
        String code = resultSet.getString("CODE");
        LetterEncryption letterCode = new LetterEncryption(letter, code.charAt(0));
        this.cache.put(Character.valueOf(letter), letterCode);
        return letterCode;
    }

    public void handleException(@Parameter Exception ex) throws Throwable {
        ex.printStackTrace();
        throw ex;
    }

    @FlowInterface
    public static interface PageFlows {
        public void retrieveFromDatabase(char var1);
    }
}

