/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.tutorial.jwthttpserver;

import net.officefloor.server.http.HttpException;
import net.officefloor.server.http.HttpStatus;
import net.officefloor.tutorial.jwthttpserver.Claims;
import net.officefloor.tutorial.jwthttpserver.Identity;
import net.officefloor.web.HttpObject;
import net.officefloor.web.ObjectResponse;
import net.officefloor.web.jwt.authority.JwtAuthority;

public class JwtTokens {
    public void login(Credentials credentials, JwtAuthority<Identity> authority, ObjectResponse<Tokens> response) {
        if (credentials.getUsername() == null || !credentials.getUsername().equals(credentials.getPassword())) {
            throw new HttpException(HttpStatus.UNAUTHORIZED);
        }
        Identity identity = new Identity(credentials.username);
        Claims claims = this.createClaims(credentials.username);
        String refreshToken = authority.createRefreshToken((Object)identity);
        String accessToken = authority.createAccessToken((Object)claims);
        response.send((Object)new Tokens(refreshToken, accessToken));
    }

    public void refreshAccessToken(Token request, JwtAuthority<Identity> authority, ObjectResponse<Token> response) {
        Identity identity = (Identity)authority.decodeRefreshToken(request.token);
        Claims claims = this.createClaims(identity.getId());
        String accessToken = authority.createAccessToken((Object)claims);
        response.send((Object)new Token(accessToken));
    }

    private Claims createClaims(String username) {
        String[] roles = new String[]{"tutorial"};
        return new Claims(username, roles);
    }

    @HttpObject
    public static class Token {
        private String token;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Token;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        public String toString() {
            return "JwtTokens.Token(token=" + this.getToken() + ")";
        }

        public Token(String token) {
            this.token = token;
        }

        public Token() {
        }
    }

    public static class Tokens {
        private String refreshToken;
        private String accessToken;

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tokens)) {
                return false;
            }
            Tokens other = (Tokens)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tokens;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            return result;
        }

        public String toString() {
            return "JwtTokens.Tokens(refreshToken=" + this.getRefreshToken() + ", accessToken=" + this.getAccessToken() + ")";
        }

        public Tokens() {
        }

        public Tokens(String refreshToken, String accessToken) {
            this.refreshToken = refreshToken;
            this.accessToken = accessToken;
        }
    }

    @HttpObject
    public static class Credentials {
        private String username;
        private String password;

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "JwtTokens.Credentials(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }

        public Credentials() {
        }

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

