/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.servlet;

import com.mingsoft.basic.servlet.BaseServlet;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

@WebServlet(urlPatterns={"/upload"})
public class UploadServlet
extends BaseServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html;charset=utf-8");
        PrintWriter out = res.getWriter();
        String uploadPath = this.getServletContext().getRealPath(File.separator);
        String isRename = "";
        String _tempPath = String.valueOf(req.getServletContext().getRealPath(File.separator)) + "temp";
        FileUtil.createFolder((String)_tempPath);
        File tempPath = new File(_tempPath);
        int maxSize = 1000000;
        String deniedFile = ".exe,.com,.cgi,.asp";
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        factory.setRepository(tempPath);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List fileItems = upload.parseRequest(req);
            Iterator iter = fileItems.iterator();
            String regExp = ".+\\\\(.+)$";
            deniedFile.split(",");
            Pattern.compile(regExp);
            String outPath = "";
            while (iter.hasNext()) {
                FileItem item = (FileItem)iter.next();
                if (item.getFieldName().equals("uploadPath")) {
                    outPath = String.valueOf(outPath) + item.getString();
                    uploadPath = String.valueOf(uploadPath) + outPath;
                    continue;
                }
                if (item.getFieldName().equals("isRename")) {
                    isRename = item.getString();
                    continue;
                }
                if (item.getFieldName().equals("maxSize")) {
                    maxSize = Integer.parseInt(item.getString()) * 0x100000;
                    continue;
                }
                if (item.getFieldName().equals("allowedFile")) continue;
                if (item.getFieldName().equals("deniedFile")) {
                    deniedFile = item.getString();
                    continue;
                }
                if (item.isFormField()) continue;
                String name = item.getName();
                long size = item.getSize();
                if ((name == null || name.equals("")) && size == 0L) continue;
                try {
                    upload.setSizeMax((long)maxSize);
                    String fileName = String.valueOf(System.currentTimeMillis()) + name.substring(name.indexOf("."));
                    String savePath = String.valueOf(uploadPath) + File.separator;
                    FileUtil.createFolder((String)savePath);
                    if (StringUtil.isBlank((String)isRename) || Boolean.parseBoolean(isRename)) {
                        savePath = String.valueOf(savePath) + fileName;
                        outPath = String.valueOf(outPath) + fileName;
                    } else {
                        savePath = String.valueOf(savePath) + name;
                        outPath = String.valueOf(outPath) + name;
                    }
                    item.write(new File(savePath));
                    out.print(outPath.trim());
                    this.logger.debug((Object)("upload file ok return path " + outPath));
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    this.logger.debug((Object)e);
                }
            }
        }
        catch (FileUploadException e) {
            this.logger.debug((Object)e);
        }
    }
}

